<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Services\LiveStockService;
use App\Traits\Vrm\Model\ApiResponseTrait;
use Illuminate\Http\Client\RequestException;

class StockController extends Controller
{
    use ApiResponseTrait;

    /**
     * Fetch all NSE stocks.
     */
    public function index(): \Illuminate\Http\JsonResponse
    {
        try {
            $data = app(LiveStockService::class)->getAllStocks();

            return $this->success($data, 'Stocks list retrieved.');
        } catch (RequestException $e) {
            $status = $e->response?->status() ?? 502;

            return $this->error(
                'Failed to fetch stocks from NSE: '.$e->getMessage(),
                $status >= 400 && $status < 600 ? $status : 502
            );
        }
    }

    /**
     * Fetch NSE stock data by symbol (e.g. Safaricom).
     */
    public function show(string $symbol): \Illuminate\Http\JsonResponse
    {
        try {
            $data = app(LiveStockService::class)->getStock($symbol);

            return $this->success($data, 'Stock data retrieved.');
        } catch (RequestException $e) {
            $status = $e->response?->status() ?? 502;

            return $this->error(
                'Failed to fetch stock from NSE: '.$e->getMessage(),
                $status >= 400 && $status < 600 ? $status : 502
            );
        }
    }
}
