<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureUserIsMember
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (! $request->user() || ! $request->user()->isMember()) {
            if ($request->expectsJson()) {
                abort(403, __('Unauthorized: Member access only.'));
            }

            return redirect()->route('login')->with('error', __('You must be a member to access this page.'));
        }

        return $next($request);
    }
}
