<?php

namespace App\Jobs\V1;

use App\Jobs\Vrm\SendMail;
use App\Mail\PasswordResetMail;
use App\Models\User;
use App\Services\Sms\SmsNotifier;
use Illuminate\Bus\Queueable;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Throwable;

class SendPasswordResetJob
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected User $user;

    protected string $resetCode;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(User $user, string $resetCode)
    {
        $this->user = $user;
        $this->resetCode = $resetCode;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        app(SmsNotifier::class)->sendToPhone(
            $this->user->phone,
            "Your Ziidi Trader password reset code is {$this->resetCode}.",
            'user_otp'
        );

        try {
            SendMail::dispatch($this->user->email, mailable: new PasswordResetMail($this->user->name, $this->resetCode), notificationType: 'user_otp');
        } catch (Throwable $exception) {
            Log::warning('Password reset email dispatch failed.', [
                'user_id' => $this->user->id,
                'email' => $this->user->email,
                'message' => $exception->getMessage(),
            ]);
        }
    }
}
