<?php

namespace App\Jobs\V1;

use App\Jobs\Vrm\SendMail;
use App\Mail\WelcomeUserMail;
use App\Models\User;
use App\Services\Sms\SmsNotifier;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Support\Facades\Log;
use Throwable;

class SendWelcomeUserJob
{
    use Queueable;

    protected $user;

    /**
     * Create a new job instance.
     */
    public function __construct(User $user)
    {
        $this->user = $user;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        app(SmsNotifier::class)->sendToPhone(
            $this->user->phone,
            'Welcome to Ziidi Trader. Your account is now active.',
            'user_welcome'
        );

        try {
            SendMail::dispatch($this->user->email, mailable: new WelcomeUserMail($this->user->name), notificationType: 'user_welcome');
        } catch (Throwable $exception) {
            Log::warning('Welcome email dispatch failed.', [
                'user_id' => $this->user->id,
                'email' => $this->user->email,
                'message' => $exception->getMessage(),
            ]);
        }
    }
}
