<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class AdminDepositMail extends Mailable implements ShouldQueue
{
    use Queueable;
    use SerializesModels;

    public function __construct(
        public string $memberName,
        public string $memberEmail,
        public float $amount,
        public string $currencyCode,
        public string $status,
        public string $channel = 'wallet',
        public ?string $reference = null,
    ) {}

    public function envelope(): Envelope
    {
        $statusLabel = ucfirst($this->status);

        return new Envelope(
            subject: "Deposit {$statusLabel}: {$this->currencyCode} ".number_format($this->amount, 2),
        );
    }

    public function content(): Content
    {
        $statusLabel = ucfirst($this->status);
        $channelLabel = strtoupper($this->channel);

        return new Content(
            view: 'emails.simple-message',
            with: [
                'greeting' => 'Hello Admin,',
                'intro' => "A member deposit has been {$this->status}.",
                'lines' => [
                    "Member: {$this->memberName} ({$this->memberEmail})",
                    "Channel: {$channelLabel}",
                    "Amount: {$this->currencyCode} ".number_format($this->amount, 2),
                    "Status: {$statusLabel}",
                    'Reference: '.($this->reference ?: 'N/A'),
                ],
                'actionText' => 'Open Wallet Requests',
                'actionUrl' => route('admin.wallet-requests.index'),
                'outro' => 'Please review and monitor this transaction.',
            ],
        );
    }
}
