<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class DepositRequestRejectedMail extends Mailable
{
    use Queueable;
    use SerializesModels;

    public function __construct(
        public string $recipientName,
        public string $currencyCode,
        public float $amount,
        public ?string $reference = null,
    ) {}

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Deposit Request Rejected',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.simple-message',
            with: [
                'greeting' => 'Hello '.$this->recipientName.',',
                'intro' => 'Your deposit request has been rejected.',
                'lines' => [
                    'Amount: '.$this->currencyCode.' '.number_format($this->amount, 2),
                    'Reference: '.($this->reference ?: 'N/A'),
                ],
                'outro' => 'If you need help, please contact support.',
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
