<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class PasswordResetMail extends Mailable implements ShouldQueue
{
    use Queueable;
    use SerializesModels;

    public function __construct(
        public string $recipientName,
        public string $resetCode,
    ) {}

    public function envelope(): Envelope
    {
        return new Envelope(subject: 'Reset Your Password');
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.simple-message',
            with: [
                'greeting' => 'Hello '.$this->recipientName.',',
                'intro' => 'Use this 8-digit code to reset your password: '.$this->resetCode,
                'lines' => ['Enter this code on the reset password page to continue.'],
                'outro' => 'This code expires in 60 minutes. If you did not request a password reset, no further action is required.',
            ],
        );
    }
}
