<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class PasswordUpdatedMail extends Mailable implements ShouldQueue
{
    use Queueable;
    use SerializesModels;

    public function envelope(): Envelope
    {
        return new Envelope(subject: 'Your Password Has Been Updated');
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.simple-message',
            with: [
                'intro' => 'This is a confirmation that the password for your account has been successfully updated.',
                'outro' => 'If you did not make this change, please contact our support team immediately.',
            ],
        );
    }
}
