<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class VerifyEmailMail extends Mailable implements ShouldQueue
{
    use Queueable;
    use SerializesModels;

    public function __construct(
        public string $recipientName,
        public string $verificationCode,
    ) {}

    public function envelope(): Envelope
    {
        return new Envelope(subject: 'Verify Your Email Address');
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.simple-message',
            with: [
                'greeting' => 'Hello '.$this->recipientName.',',
                'intro' => 'Thank you for registering! Use this 8-digit verification code to activate your account: '.$this->verificationCode,
                'lines' => ['Enter this code on the verification page to complete account setup.'],
                'outro' => 'If you did not create an account, no further action is required. This code expires soon.',
            ],
        );
    }
}
