<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class WelcomeUserMail extends Mailable implements ShouldQueue
{
    use Queueable;
    use SerializesModels;

    public function __construct(public string $recipientName) {}

    public function envelope(): Envelope
    {
        return new Envelope(subject: 'Welcome to Winda Investment Forum!');
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.simple-message',
            with: [
                'greeting' => 'Dear, '.$this->recipientName.'!',
                'intro' => 'Your email has been successfully verified. We are excited to have you as part of our community!',
                'outro' => 'If you have any questions or need support, feel free to reach out. Thank you for joining us!',
            ],
        );
    }
}
