<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class InvestmentPackage extends Model
{
    protected $fillable = [
        'name',
        'min_amount',
        'max_amount',
        'interest_percent',
        'duration_hours',
        'description',
        'photo',
        'is_active',
        'currency_code',
    ];

    protected function casts(): array
    {
        return [
            'min_amount' => 'decimal:4',
            'max_amount' => 'decimal:4',
            'interest_percent' => 'decimal:4',
            'duration_hours' => 'integer',
            'is_active' => 'boolean',
        ];
    }

    public function investments(): HasMany
    {
        return $this->hasMany(Investment::class, 'package_id');
    }

    public function calculateExpectedReturn(float $principalAmount): float
    {
        return $principalAmount * (1 + ((float) $this->interest_percent / 100));
    }
}
