<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Notification extends Model
{
    /** @use HasFactory<\Database\Factories\NotificationFactory> */
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'type',
        'title',
        'body',
        'data',
        'action_url',
        'priority',
        'is_active',
        'expires_at',
    ];

    protected function casts(): array
    {
        return [
            'data' => 'array',
            'priority' => 'integer',
            'is_active' => 'boolean',
            'expires_at' => 'datetime',
        ];
    }

    public function states(): HasMany
    {
        return $this->hasMany(NotificationState::class);
    }
}
