<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PortfolioHolding extends Model
{
    protected $fillable = [
        'user_id',
        'security_id',
        'quantity',
        'reserved_quantity',
        'average_buy_price',
        'total_invested',
    ];

    protected function casts(): array
    {
        return [
            'quantity' => 'integer',
            'reserved_quantity' => 'integer',
            'average_buy_price' => 'decimal:4',
            'total_invested' => 'decimal:4',
        ];
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function security(): BelongsTo
    {
        return $this->belongsTo(Security::class);
    }

    public function currentValue(): float
    {
        return (float) $this->quantity * $this->security->latestPrice();
    }
}
