<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SecurityLog extends Model
{
    /** @use HasFactory<\Database\Factories\SecurityLogFactory> */
    use HasFactory;

    protected $table = 'securities_logs';

    protected $fillable = [
        'security_id',
        'price',
        'change_percent',
        'source',
        'logged_at',
    ];

    protected function casts(): array
    {
        return [
            'price' => 'decimal:4',
            'change_percent' => 'decimal:4',
            'logged_at' => 'datetime',
        ];
    }

    public function security(): BelongsTo
    {
        return $this->belongsTo(Security::class);
    }
}
