<?php

namespace App\Services;

use Vormia\ATUMultiCurrency\Models\Currency;

class DefaultCurrencyService
{
    public function code(): string
    {
        $fallbackCode = strtoupper((string) config('atu-multi-currency.default_currency', 'KSH'));

        try {
            $defaultCurrency = Currency::query()
                ->where('is_default', true)
                ->where('is_active', true)
                ->first();

            if ($defaultCurrency !== null && is_string($defaultCurrency->code) && trim($defaultCurrency->code) !== '') {
                return strtoupper(trim($defaultCurrency->code));
            }
        } catch (\Throwable) {
            // Fallback to config when ATU tables are not available.
        }

        return $fallbackCode !== '' ? $fallbackCode : 'KSH';
    }
}
