<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        $middleware->alias([
            'member' => \App\Http\Middleware\EnsureUserIsMember::class,
            'role' => \App\Http\Middleware\Vrm\CheckRole::class,
            'module' => \App\Http\Middleware\Vrm\CheckModule::class,
            'permission' => \App\Http\Middleware\Vrm\CheckPermission::class,
            'api-auth' => \App\Http\Middleware\Vrm\ApiAuthenticate::class,
            'authority' => \App\Http\Middleware\Vrm\CheckAuthority::class,
        ]);

        $middleware->validateCsrfTokens(except: [
            'api/mpesa/callback',
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })->create();
