<?php

namespace Database\Factories;

use App\Models\Notification;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Notification>
 */
class NotificationFactory extends Factory
{
    protected $model = Notification::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'type' => $this->faker->randomElement([
                'wallet.payment_success',
                'wallet.deposit',
                'wallet.withdrawal',
                'card.virtual.request',
            ]),
            'title' => $this->faker->randomElement([
                'Payment Success',
                'M-Pesa to LOOP',
                'Virtual Card Request',
            ]),
            'body' => $this->faker->sentence(8),
            'data' => ['reference' => $this->faker->uuid()],
            'action_url' => '/member/transactions',
            'priority' => $this->faker->numberBetween(1, 3),
            'is_active' => true,
            'expires_at' => null,
        ];
    }
}
