<?php

namespace Database\Factories;

use App\Models\Notification;
use App\Models\NotificationState;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\NotificationState>
 */
class NotificationStateFactory extends Factory
{
    protected $model = NotificationState::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'notification_id' => Notification::factory(),
            'user_id' => User::factory(),
            'read_at' => null,
            'seen_at' => null,
            'cleared_at' => null,
            'is_active' => true,
        ];
    }

    public function read(): static
    {
        return $this->state(fn (): array => ['read_at' => now()]);
    }
}
