<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Security>
 */
class SecurityFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $ticker = strtoupper(fake()->unique()->lexify('???'));
        $price = fake()->randomFloat(4, 0.1, 500);

        return [
            'name' => $ticker.' Corporation',
            'trading_name' => $ticker,
            'currency_code' => 'USD',
            'initial_listing_amount' => $price,
            'current_amount' => $price,
            'min_shares' => 1,
            'max_shares_purchase' => 0,
            'max_shares_holding' => 0,
            'is_active' => true,
        ];
    }
}
