<?php

namespace Database\Factories;

use App\Models\Security;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\SecurityLog>
 */
class SecurityLogFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'security_id' => Security::factory(),
            'price' => fake()->randomFloat(4, 0.01, 9999),
            'change_percent' => fake()->randomFloat(4, -10, 10),
            'source' => 'manual',
            'logged_at' => now(),
        ];
    }
}
