<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (! Schema::hasTable('wallet_transactions')) {
            Schema::create('wallet_transactions', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('wallet_id');
                $table->unsignedBigInteger('user_id');
                $table->string('type', 30);
                $table->string('status', 30)->default('completed');
                $table->decimal('amount', 20, 4);
                $table->string('currency_code', 4)->default('KSH');
                $table->string('description')->nullable();
                $table->json('meta')->nullable();
                $table->unsignedBigInteger('approved_by')->nullable();
                $table->timestamp('approved_at')->nullable();
                $table->timestamps();

                $table->index(['user_id', 'type', 'status']);
            });
        }

        if (Schema::hasTable('wallet_transactions') && Schema::hasTable('wallets')) {
            try {
                Schema::table('wallet_transactions', function (Blueprint $table): void {
                    $table->foreign('wallet_id')->references('id')->on('wallets')->cascadeOnDelete();
                });
            } catch (\Throwable $throwable) {
            }
        }

        if (Schema::hasTable('wallet_transactions') && Schema::hasTable('users')) {
            try {
                Schema::table('wallet_transactions', function (Blueprint $table): void {
                    $table->foreign('user_id')->references('id')->on('users')->cascadeOnDelete();
                });
            } catch (\Throwable $throwable) {
            }

            try {
                Schema::table('wallet_transactions', function (Blueprint $table): void {
                    $table->foreign('approved_by')->references('id')->on('users')->nullOnDelete();
                });
            } catch (\Throwable $throwable) {
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wallet_transactions');
    }
};
