<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('wallet_transactions', function (Blueprint $table): void {
            if (! Schema::hasColumn('wallet_transactions', 'phone_number')) {
                $table->string('phone_number', 30)->nullable()->after('description');
            }
            if (! Schema::hasColumn('wallet_transactions', 'transaction_code')) {
                $table->string('transaction_code', 50)->nullable()->after('phone_number');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('wallet_transactions', function (Blueprint $table): void {
            $table->dropColumn(['phone_number', 'transaction_code']);
        });
    }
};
