<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('wallet_transactions', function (Blueprint $table) {
            $table->string('provider')->nullable()->after('type'); // e.g. 'mpesa', 'bank'
            $table->string('provider_status', 50)->nullable()->after('status');
            $table->string('merchant_request_id')->nullable()->after('transaction_code')->index();
            $table->string('checkout_request_id')->nullable()->after('merchant_request_id')->index();
            $table->string('provider_reference')->nullable()->after('checkout_request_id');
            $table->json('provider_response')->nullable()->after('provider_reference');
            $table->timestamp('processed_at')->nullable()->after('approved_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('wallet_transactions', function (Blueprint $table) {
            $table->dropColumn([
                'provider',
                'provider_status',
                'merchant_request_id',
                'checkout_request_id',
                'provider_reference',
                'provider_response',
                'processed_at',
            ]);
        });
    }
};
