@php
	$theme = auth()->check() ? (auth()->user()->preferences['theme'] ?? 'light') : 'light';
@endphp
<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="h-full {{ $theme === 'dark' ? 'dark' : '' }}">

	<head>
		<meta charset="utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1.0" />
		<title>{{ $title ?? config('app.name') }}</title>
		<link rel="icon" href="/favicon.ico" sizes="any">
		<link rel="icon" href="/favicon.svg" type="image/svg+xml">
		<link rel="apple-touch-icon" href="/apple-touch-icon.png">
		<link rel="preconnect" href="https://fonts.bunny.net">
		<link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />
		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
		@vite(['resources/css/app.css', 'resources/js/app.js'])
		<script>
			(function() {
				var key = 'app.theme';
				var fluxKey = 'flux.appearance';
				var theme = @json($theme);
				var stored = window.localStorage.getItem(key) || theme;
				if (stored !== 'light' && stored !== 'dark') stored = 'light';
				window.localStorage.setItem(key, stored);
				window.localStorage.setItem(fluxKey, stored);
				if (stored === 'dark') document.documentElement.classList.add('dark');
				else document.documentElement.classList.remove('dark');
			})();
		</script>
		@livewireStyles
	</head>

	<body x-data="{ pageLoading: false }"
		x-on:livewire:navigate.window="pageLoading = true"
		x-on:livewire:navigated.window="pageLoading = false"
		class="h-dvh overflow-hidden bg-background text-foreground antialiased">
		<div x-show="pageLoading" x-transition.opacity.duration.200ms
			class="pointer-events-none fixed inset-0 z-[90] flex items-center justify-center bg-background/65 backdrop-blur-sm">
			<div class="inline-flex items-center gap-3 rounded-full border border-border bg-card px-4 py-2 text-sm font-medium text-foreground shadow-sm">
				<i class="fa-solid fa-spinner animate-spin text-primary"></i>
				<span>{{ __('Loading...') }}</span>
			</div>
		</div>
		<div class="h-dvh overflow-hidden bg-background">
			@include('partials.trading.desktop-sidebar')
			<div class="h-full lg:ml-56 lg:mr-72">
				{{-- @include('partials.trading.desktop-topbar') --}}
				<div class="relative mx-auto flex h-full max-w-lg flex-col lg:max-w-2xl">
					<div class="min-h-0 flex-1 overflow-y-auto overscroll-contain pb-20 lg:pb-6 lg:[scrollbar-width:none] lg:[-ms-overflow-style:none] lg:[&::-webkit-scrollbar]:hidden">
						{{ $slot }}
					</div>
				</div>
			</div>
			@include('partials.trading.desktop-right-sidebar')
			<div class="lg:hidden">
				@include('partials.trading.bottom-nav')
			</div>
		</div>
		<script>
			document.addEventListener('livewire:init', () => {
				Livewire.on('theme-changed', ({ theme }) => {
					document.documentElement.classList.toggle('dark', theme === 'dark');
					if (window.localStorage) {
						window.localStorage.setItem('app.theme', theme);
						window.localStorage.setItem('flux.appearance', theme);
					}
				});
			});
		</script>
		@fluxScripts
		@livewireScripts
	</body>

</html>
