<?php

use App\Models\CommunityPost;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Attributes\Locked;
use Livewire\Component;

new #[Layout('layouts.trading')] class extends Component {
    #[Locked]
    public int $postId;

    public function mount(int $post): void
    {
        $this->postId = $post;
        $this->ensureVisiblePostExists();
    }

    #[Computed]
    public function post(): CommunityPost
    {
        return CommunityPost::query()
            ->published()
            ->with('author:id,name,username')
            ->findOrFail($this->postId);
    }

    private function ensureVisiblePostExists(): void
    {
        CommunityPost::query()->published()->findOrFail($this->postId);
    }
}; ?>

<div>
    @include('partials.trading.topbar', ['title' => __('Community Center')])

    <div class="space-y-5 px-4 py-4">
        <article class="rounded-2xl border border-border bg-card p-4 shadow-sm sm:p-5">
            <div class="flex items-center justify-between gap-2">
                <div>
                    <p class="text-sm font-semibold text-foreground">{{ $this->post->author?->name ?? __('Admin') }}</p>
                    <p class="mt-1 text-xs text-muted-foreground">{{ optional($this->post->published_at)->diffForHumans() }}</p>
                </div>
            </div>

            <h1 class="mt-3 text-lg font-bold text-foreground">{{ $this->post->title }}</h1>
            <div class="prose prose-sm mt-4 max-w-none text-foreground dark:prose-invert">
                {!! $this->post->body_html !!}
            </div>
        </article>
    </div>
</div>
