<?php

use App\Models\NotificationState;
use Livewire\Attributes\Computed;
use Livewire\Component;

new class extends Component {
    #[Computed]
    public function unreadCount(): int
    {
        return NotificationState::query()
            ->where('user_id', auth()->id())
            ->where('is_active', true)
            ->whereNull('read_at')
            ->whereNull('cleared_at')
            ->whereNull('deleted_at')
            ->count();
    }
}; ?>

<div wire:poll.10s>
    <a href="{{ route('member.notifications') }}"
        wire:navigate
        class="relative inline-flex h-10 w-10 items-center justify-center rounded-full border border-border bg-card text-foreground transition hover:bg-muted/70"
        aria-label="{{ __('Notifications') }}">
        <i class="fa-regular fa-bell text-base"></i>

        @if ($this->unreadCount > 0)
            <span class="absolute -right-0.5 -top-0.5 inline-flex min-h-5 min-w-5 items-center justify-center rounded-full bg-destructive px-1 text-[10px] font-bold leading-none text-white">
                {{ $this->unreadCount > 99 ? '99+' : $this->unreadCount }}
            </span>
        @endif
    </a>
</div>
