@extends('layouts.member.auth')

@section('content')
    <div class="mb-4">
        <h1 class="text-xl font-bold text-foreground">{{ __('Create an account') }}</h1>
        <p class="text-sm text-muted-foreground mt-1">{{ __('Enter your details below to create your account') }}</p>
    </div>

    @if (session('status'))
        <div class="rounded-lg bg-primary/10 border border-primary/30 px-4 py-3 text-sm text-foreground mb-4">
            {{ session('status') }}
        </div>
    @endif

    <form method="POST" action="{{ route('register.store') }}" class="flex flex-col gap-4">
        @csrf

        <div>
            <label for="name" class="required block text-sm font-medium text-foreground mb-1">{{ __('Name') }}</label>
            <input id="name" type="text" name="name" value="{{ old('name') }}" required autofocus autocomplete="name"
                placeholder="{{ __('Full name') }}"
                class="w-full bg-card border border-border rounded-lg py-3 px-4 text-foreground placeholder:text-muted-foreground focus:outline-none focus:ring-2 focus:ring-primary" />
            @error('name')
                <p class="text-destructive text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div>
            <label for="email" class="required block text-sm font-medium text-foreground mb-1">{{ __('Email address') }}</label>
            <input id="email" type="email" name="email" value="{{ old('email') }}" required autocomplete="email"
                placeholder="email@example.com"
                class="w-full bg-card border border-border rounded-lg py-3 px-4 text-foreground placeholder:text-muted-foreground focus:outline-none focus:ring-2 focus:ring-primary" />
            @error('email')
                <p class="text-destructive text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div>
            <label for="phone" class="required block text-sm font-medium text-foreground mb-1">{{ __('Phone number') }}</label>
            <input id="phone" type="tel" name="phone" value="{{ old('phone') }}" required autocomplete="tel"
                placeholder="{{ __('e.g. 254712345678') }}"
                class="w-full bg-card border border-border rounded-lg py-3 px-4 text-foreground placeholder:text-muted-foreground focus:outline-none focus:ring-2 focus:ring-primary" />
            @error('phone')
                <p class="text-destructive text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div>
            <label for="password" class="required block text-sm font-medium text-foreground mb-1">{{ __('Password') }}</label>
            <input id="password" type="password" name="password" required autocomplete="new-password"
                placeholder="{{ __('Password') }}"
                class="w-full bg-card border border-border rounded-lg py-3 px-4 text-foreground placeholder:text-muted-foreground focus:outline-none focus:ring-2 focus:ring-primary" />
            @error('password')
                <p class="text-destructive text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div>
            <label for="password_confirmation" class="required block text-sm font-medium text-foreground mb-1">{{ __('Confirm password') }}</label>
            <input id="password_confirmation" type="password" name="password_confirmation" required autocomplete="new-password"
                placeholder="{{ __('Confirm password') }}"
                class="w-full bg-card border border-border rounded-lg py-3 px-4 text-foreground placeholder:text-muted-foreground focus:outline-none focus:ring-2 focus:ring-primary" />
        </div>

        <button type="submit" class="w-full bg-primary text-primary-foreground font-semibold py-3 rounded-lg hover:opacity-90 transition-opacity">
            {{ __('Create account') }}
        </button>
    </form>

    <p class="text-center text-sm text-muted-foreground mt-4">
        {{ __('Already have an account?') }}
        <a href="{{ route('login') }}" class="text-primary font-semibold" wire:navigate>{{ __('Log in') }}</a>
    </p>
@endsection
