@extends('layouts.member.auth')

@section('content')
    <p class="text-center text-foreground">
        {{ __('Enter the 8-digit verification code sent to your email and SMS to activate your account.') }}
    </p>

    @if (session('status') == 'verification-link-sent')
        <p class="text-center text-sm font-medium text-primary">
            {{ __('A new verification code has been sent to your email and SMS.') }}
        </p>
    @endif

    @if (session('status') == 'verification-code-verified')
        <p class="text-center text-sm font-medium text-primary">
            {{ __('Verification successful. Redirecting to your dashboard...') }}
        </p>
    @endif

    <div class="flex flex-col items-center gap-3">
        <form method="POST" action="{{ route('verification.code.verify') }}" class="w-full flex flex-col gap-2">
            @csrf
            <label for="verification_code" class="text-sm text-muted-foreground">{{ __('Verification Code') }}</label>
            <input
                id="verification_code"
                name="verification_code"
                type="text"
                inputmode="numeric"
                maxlength="8"
                value="{{ old('verification_code') }}"
                class="w-full rounded-lg border border-border bg-background px-3 py-2 text-foreground"
                placeholder="{{ __('Enter 8-digit code') }}"
                required
            />
            @error('verification_code')
                <p class="text-sm text-red-500">{{ $message }}</p>
            @enderror
            <button type="submit" class="w-full bg-primary text-primary-foreground font-semibold py-3 rounded-lg hover:opacity-90 transition-opacity">
                {{ __('Verify Code') }}
            </button>
        </form>

        <form method="POST" action="{{ route('verification.send') }}" class="w-full">
            @csrf
            <button type="submit" class="w-full bg-primary text-primary-foreground font-semibold py-3 rounded-lg hover:opacity-90 transition-opacity">
                {{ __('Resend verification code') }}
            </button>
        </form>

        <form method="POST" action="{{ route('logout') }}" class="w-full">
            @csrf
            <button type="submit" class="w-full text-sm text-muted-foreground hover:text-foreground transition-colors py-2">
                {{ __('Log out') }}
            </button>
        </form>
    </div>
@endsection
