@props([
    'receipt' => [],
    'logoUrl' => null,
])
@php
    $logoUrl = $logoUrl ?? asset('media/zidii/assets/img/ziidi3.png');
    $customerName = $receipt['customerName'] ?? 'Customer';
    $date = $receipt['date'] ?? '';
    $amount = $receipt['amount'] ?? '0.00';
    $phoneNumber = $receipt['phoneNumber'] ?? 'N/A';
    $transactionNo = $receipt['transactionNo'] ?? 'N/A';
    $paymentType = $receipt['paymentType'] ?? 'Deposit';
    $maskedPhone = $receipt['maskedPhone'] ?? 'N/A';
    $isWithdrawal = $paymentType === 'Withdrawal';
    $greetingText = $isWithdrawal ? 'Thank you for making your withdrawal with Ziidi Trader.' : 'Thank you for making your payment with Ziidi Trader.';
    $amountLabel = $isWithdrawal ? 'Total Amount Withdrawn:' : 'Total Amount Paid:';
@endphp
<div class="receipt-container mx-auto max-w-[420px] rounded-xl overflow-hidden border border-receipt-border bg-receipt shadow-lg print:shadow-none print:border-0 print:max-w-full">
    {{-- Header --}}
    <div class="p-6 pb-2">
        <img src="{{ $logoUrl }}" alt="Ziidi Trader" class="h-16 object-contain" />
    </div>

    {{-- Paper plane illustration --}}
    <div class="flex justify-center py-6">
        <svg width="140" height="95" viewBox="0 0 140 95" class="text-primary">
            <defs>
                <linearGradient id="planeGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                    <stop offset="0%" stop-color="#5dd472" />
                    <stop offset="100%" stop-color="#2cb34a" />
                </linearGradient>
                <linearGradient id="planeShadow" x1="0%" y1="0%" x2="100%" y2="100%">
                    <stop offset="0%" stop-color="#239b3d" />
                    <stop offset="100%" stop-color="#1d8533" />
                </linearGradient>
            </defs>
            <polygon points="10,55 130,10 80,58 130,10 88,90 68,55 88,90 10,55" fill="url(#planeGrad)" />
            <polygon points="68,55 80,58 88,90" fill="url(#planeShadow)" opacity="0.8" />
        </svg>
    </div>

    {{-- Greeting --}}
    <div class="text-center px-6 pb-4">
        <h2 class="text-2xl font-bold text-primary">
            Hi {{ $customerName }},
        </h2>
        <p class="text-muted-foreground mt-1 text-sm">
            {{ $greetingText }}
        </p>
    </div>

    {{-- Amount + Details --}}
    <div class="px-6 pb-6">
        <div class="flex gap-4">
            <div class="bg-primary rounded-lg p-5 flex-shrink-0 w-[170px] flex flex-col justify-center">
                <p class="text-primary-foreground text-xs font-medium opacity-90">
                    {{ $amountLabel }}
                </p>
                <p class="text-primary-foreground text-xl font-bold mt-1">
                    KSH {{ $amount }}
                </p>
                <div class="border-t border-primary-foreground/30 my-2"></div>
                <p class="text-primary-foreground text-[11px] opacity-80">
                    Phone Number: {{ $phoneNumber }}
                </p>
            </div>

            <div class="flex flex-col justify-center text-sm space-y-2">
                <div>
                    <span class="text-receipt-label text-xs">Date:</span>
                    <span class="text-receipt-value text-xs font-medium">{{ $date }}</span>
                </div>
                <div>
                    <span class="text-receipt-label text-xs">Received From:</span>
                    <span class="text-receipt-value text-xs font-medium">{{ $customerName }}</span>
                </div>
                <div>
                    <span class="text-receipt-label text-xs">Transaction No:</span>
                    <span class="text-receipt-value text-xs font-bold">{{ $transactionNo }}</span>
                </div>
                <div>
                    <span class="text-receipt-label text-xs">Payment Type:</span>
                    <span class="text-receipt-value text-xs font-bold">{{ $paymentType }}</span>
                </div>
                <div>
                    <span class="text-receipt-label text-xs">Phone Number:</span>
                    <span class="text-receipt-value text-xs font-bold">{{ $maskedPhone }}</span>
                </div>
            </div>
        </div>
    </div>

    {{-- Barcode area --}}
    <div class="flex flex-col items-center px-6 pb-2">
        <div class="w-full max-w-[280px] h-12 flex items-end gap-px">
            @foreach (range(0, 59) as $i)
                <div
                    class="flex-1 bg-foreground"
                    style="height: {{ $i % 3 === 0 ? 60 : 100 }}%"
                ></div>
            @endforeach
        </div>
        <p class="text-primary text-xs font-medium mt-2 tracking-widest">ETR</p>
    </div>

    {{-- Footer --}}
    <div class="mt-8 px-6 pb-6">
        <div class="border-t-2 border-primary pt-3 flex items-center gap-2">
            <img src="{{ $logoUrl }}" alt="Ziidi Trader" class="h-10 object-contain" />
        </div>
    </div>
</div>
