@props(['title' => config('app.name'), 'greeting' => null])

@php
	$greetings = [__('Good Night'), __('Good Morning'), __('Good Afternoon'), __('Good Evening')];
	// Fallback for SSR / no-JS: same ranges as client (server time)
	$hour = (int) now()->format('H');
	$resolvedGreeting =
	    $greeting ??
	    match (true) {
	        $hour < 5 => $greetings[0],
	        $hour < 12 => $greetings[1],
	        $hour < 17 => $greetings[2],
	        $hour < 21 => $greetings[3],
	        default => $greetings[0],
	    };
@endphp

<header x-data="{
    scrolled: false,
    greeting: @js($resolvedGreeting),
    greetings: @js($greetings),
    updateGreeting() {
        const h = new Date().getHours();
        this.greeting = h < 5 ? this.greetings[0] : h < 12 ? this.greetings[1] : h < 17 ? this.greetings[2] : h < 21 ? this.greetings[3] : this.greetings[0];
    }
}" x-init="scrolled = window.scrollY > 6;
updateGreeting();
window.addEventListener('scroll', () => scrolled = window.scrollY > 6)"
	:class="scrolled ? 'bg-zinc-950 border-zinc-800' : 'bg-background border-border/80'"
	class="sticky top-0 z-40 border-b px-4 py-3 transition-colors duration-200">
	<div class="flex items-center justify-between gap-3">
		<div class="min-w-0">
			<h1 class="truncate font-display text-lg font-bold text-foreground sm:text-xl">{{ config('app.name', $title) }}</h1>
			<p class="truncate text-sm font-medium text-muted-foreground" x-text="greeting">{{ $resolvedGreeting }}</p>
		</div>
		<div class="flex items-center gap-3">
			<livewire:front.theme-switcher />
			<livewire:front.notifications-bell />
			<a href="{{ route('logout') }}" class="inline-flex items-center text-sm transition-opacity hover:opacity-80"
				:class="scrolled ? 'text-white' : 'text-foreground'" aria-label="{{ __('Log out') }}"
				onclick="event.preventDefault(); document.getElementById('logout-form-trading').submit();">
				<i class="fa-solid fa-right-from-bracket h-6 w-6" :class="scrolled ? 'text-white' : 'text-foreground'"></i>
			</a>
			<form id="logout-form-trading" action="{{ route('logout') }}" method="POST" class="hidden">
				@csrf
			</form>
		</div>
	</div>
</header>
