@php
	$customerName = $receipt['customerName'] ?? 'Customer';
	$date = $receipt['date'] ?? '';
	$amount = $receipt['amount'] ?? '0.00';
	$phoneNumber = $receipt['phoneNumber'] ?? 'N/A';
	$transactionNo = $receipt['transactionNo'] ?? 'N/A';
	$paymentType = $receipt['paymentType'] ?? 'Deposit';
	$maskedPhone = $receipt['maskedPhone'] ?? 'N/A';
	$isWithdrawal = $paymentType === 'Withdrawal';
	$primary = '#2db548';
	$primaryLight = '#5dd472';
	$primaryDark = '#2cb34a';
	$greetingText = $isWithdrawal
	    ? 'Thank you for making your withdrawal with Ziidi Trader.'
	    : 'Thank you for making your payment with Ziidi Trader.';
	$amountLabel = $isWithdrawal ? 'Total Amount Withdrawn:' : 'Total Amount Paid:';
@endphp
<!DOCTYPE html>
<html lang="en">

	<head>
		<meta charset="UTF-8">
		<title>Receipt</title>
		<style>
			body {
				margin: 0;
				padding: 0;
				font-family: Arial, Helvetica, sans-serif;
				background: #fff;
			}

			.receipt-wrap {
				width: 500px;
				margin: 0 auto;
				background: #fff;
				border: 1px solid #e5e7eb;
				border-radius: 12px;
				overflow: hidden;
				box-sizing: border-box;
				page-break-inside: avoid;
			}

			.p-6 {
				padding: 16px;
			}

			.pb-2 {
				padding-bottom: 8px;
			}

			.py-6 {
				padding-top: 16px;
				padding-bottom: 16px;
			}

			.text-center {
				text-align: center;
			}

			.receipt-header img {
				height: 48px;
				width: auto;
				object-fit: contain;
				display: block;
			}

			.plane-cell {
				text-align: center;
				padding: 10px 0;
			}

			.greeting-title {
				font-size: 22px;
				font-weight: 700;
				color: {{ $primary }};
				margin: 0 0 4px;
			}

			.greeting-text {
				font-size: 14px;
				color: #6b7280;
				margin: 0;
			}

			.row {
				display: table;
				width: 100%;
				border-collapse: collapse;
			}

			.amount-box {
				display: table-cell;
				width: 165px;
				background: {{ $primary }};
				color: #fff;
				padding: 16px;
				border-radius: 8px;
				vertical-align: middle;
			}

			.amount-label {
				font-size: 12px;
				font-weight: 500;
				opacity: 0.9;
				margin: 0;
			}

			.amount-value {
				font-size: 22px;
				font-weight: 700;
				margin: 4px 0 0;
			}

			.amount-divider {
				border-top: 1px solid rgba(255, 255, 255, 0.3);
				margin: 8px 0;
				padding-top: 8px;
			}

			.amount-phone {
				font-size: 11px;
				opacity: 0.8;
				margin: 0;
			}

			.details-cell {
				display: table-cell;
				padding-left: 12px;
				vertical-align: middle;
				font-size: 12px;
			}

			.detail-row {
				margin-bottom: 8px;
			}

			.detail-label {
				color: #6b7280;
			}

			.detail-value {
				color: #1f2937;
				font-weight: 500;
			}

			.detail-value-bold {
				font-weight: 700;
			}

			.barcode-wrap {
				padding: 0 16px 2px;
				text-align: center;
			}

			.barcode-bars {
				height: 48px;
				display: table;
				width: 100%;
				max-width: 280px;
				margin: 0 auto;
				border-collapse: collapse;
				table-layout: fixed;
			}

			.barcode-bar {
				display: table-cell;
				background: #1f2937;
				vertical-align: bottom;
			}

			.barcode-text {
				font-size: 12px;
				font-weight: 500;
				color: {{ $primary }};
				letter-spacing: 0.2em;
				margin: 8px 0 0;
			}

			.footer-wrap {
				margin-top: 10px;
				padding: 12px 16px;
				border-top: 2px solid {{ $primary }};
			}

			.footer-wrap img {
				height: 30px;
				width: auto;
				object-fit: contain;
				display: block;
			}
		</style>
	</head>

	<body>
		<div class="receipt-wrap">
			<div class="p-6 pb-2">
				@if ($logoPath && file_exists($logoPath))
					<img src="{{ $logoPath }}" alt="Ziidi Trader" class="receipt-header" />
				@else
					<div style="font-size:24px;font-weight:700;color:{{ $primary }};">Ziidi Trader</div>
				@endif
				<div style="font-size:13px;font-weight:600;color:#374151;margin-top:2px;">M-PESA</div>
			</div>

			<div class="plane-cell">
				<svg width="140" height="95" viewBox="0 0 140 95" style="display:inline-block;">
					<defs>
						<linearGradient id="planeGrad" x1="0%" y1="0%" x2="100%" y2="100%">
							<stop offset="0%" style="stop-color:{{ $primaryLight }}" />
							<stop offset="100%" style="stop-color:{{ $primaryDark }}" />
						</linearGradient>
						<linearGradient id="planeShadow" x1="0%" y1="0%" x2="100%" y2="100%">
							<stop offset="0%" style="stop-color:#239b3d" />
							<stop offset="100%" style="stop-color:#1d8533" />
						</linearGradient>
					</defs>
					<polygon points="10,55 130,10 80,58 130,10 88,90 68,55 88,90 10,55" fill="url(#planeGrad)" />
					<polygon points="68,55 80,58 88,90" fill="url(#planeShadow)" opacity="0.8" />
				</svg>
			</div>

			<div class="p-6 text-center" style="padding-top:0;padding-bottom:8px;">
				<h2 class="greeting-title">Hi {{ $customerName }},</h2>
				<p class="greeting-text">{{ $greetingText }}</p>
			</div>

			<div class="p-6" style="padding-top:0;padding-bottom:10px;">
				<div class="row">
					<div class="amount-box">
						<p class="amount-label">{{ $amountLabel }}</p>
						<p class="amount-value">KSH {{ $amount }}</p>
						<div class="amount-divider"></div>
						<p class="amount-phone">Phone Number: {{ $phoneNumber }}</p>
					</div>
					<div class="details-cell">
						<div class="detail-row"><span class="detail-label">Date: </span><span
								class="detail-value">{{ $date }}</span></div>
						<div class="detail-row"><span class="detail-label">Received From: </span><span
								class="detail-value">{{ $customerName }}</span></div>
						<div class="detail-row"><span class="detail-label">Transaction No: </span><span
								class="detail-value detail-value-bold">{{ $transactionNo }}</span></div>
						<div class="detail-row"><span class="detail-label">Payment Type: </span><span
								class="detail-value detail-value-bold">{{ $paymentType }}</span></div>
						<div class="detail-row"><span class="detail-label">Phone Number: </span><span
								class="detail-value detail-value-bold">{{ $maskedPhone }}</span></div>
					</div>
				</div>
			</div>

			<div class="barcode-wrap">
				<table class="barcode-bars" cellspacing="0" cellpadding="0" style="height:48px;">
					<tr style="vertical-align:bottom;">
						@foreach (range(0, 59) as $i)
							<td style="width:1.666%;padding:0 1px 0 0;border:none;vertical-align:bottom;">
								<div style="height:{{ $i % 3 === 0 ? 29 : 48 }}px;background:#1f2937;"></div>
							</td>
						@endforeach
					</tr>
				</table>
				<p class="barcode-text">ETR</p>
			</div>

			<div class="footer-wrap">
				@if ($logoPath && file_exists($logoPath))
					<img src="{{ $logoPath }}" alt="Ziidi Trader" />
				@else
					<div style="font-size:18px;font-weight:700;color:{{ $primary }};">Ziidi Trader</div>
				@endif
				<div style="font-size:11px;font-weight:600;color:#374151;margin-top:2px;">M-PESA</div>
			</div>
		</div>
	</body>

</html>
