<?php

use App\Http\Controllers\Admin\DownloadWalletReceiptController as AdminDownloadWalletReceiptController;
use App\Http\Controllers\Auth\PasswordResetCodeController;
use App\Http\Controllers\Auth\VerifyEmailCodeController;
use App\Http\Controllers\Member\DownloadWalletReceiptController;
use App\Http\Controllers\TestEmailController;
use Illuminate\Support\Facades\Route;

Route::get('/', fn () => redirect()->away('https://ziidi.trade'))
    ->name('home');

Route::prefix('member')->middleware('guest')->group(function () {
    Route::get('forgot-password', [PasswordResetCodeController::class, 'create'])->name('password.request');
    Route::post('forgot-password', [PasswordResetCodeController::class, 'store'])->name('password.email');
    Route::get('reset-password', [PasswordResetCodeController::class, 'edit'])->name('password.reset');
    Route::post('reset-password', [PasswordResetCodeController::class, 'update'])->name('password.update');
});

Route::prefix('member')->name('member.')->middleware(['auth', 'verified', 'member'])->group(function () {
    Route::livewire('dashboard', 'front.dashboard')->name('dashboard');
    Route::livewire('trade', 'front.trade')->name('trade');
    Route::livewire('trade-overview', 'front.trade-overview')->name('trade-overview');
    Route::livewire('trade-now', 'front.trade')->name('trade-now');
    Route::livewire('trade-now/{security}', 'front.trade-security')->name('trade.security');
    Route::livewire('portfolio', 'front.portfolio')->name('portfolio');
    Route::livewire('deposit/mpesa', 'front.mpesa-deposit')->name('mpesa-deposit');
    Route::livewire('withdraw', 'front.withdraw')->name('withdraw');
    Route::livewire('investments', 'front.investments')->name('investments');
    Route::livewire('transactions', 'front.transactions')->name('transactions');
    Route::livewire('notifications', 'front.notifications')->name('notifications');
    Route::get('transactions/{transaction}/receipt', DownloadWalletReceiptController::class)->name('transactions.receipt.download');
    Route::livewire('transactions/{transaction}/receipt/print', 'front.receipt.show')->name('transactions.receipt.print');
    Route::livewire('account', 'front.account')->name('account');
    Route::livewire('community', 'front.community.index')->name('community.index');
    Route::livewire('community/{post}', 'front.community.show')->name('community.show');
});

Route::post('member/email/verify-code', VerifyEmailCodeController::class)
    ->middleware(['auth'])
    ->name('verification.code.verify');

// Middleware: auth, verified
Route::middleware(['auth', 'authority', 'verified'])->group(function () {
    Route::group(['prefix' => 'admin'], function () {
        Route::view('dashboard', 'dashboard')
            ->name('admin.dashboard');

        // Categories
        Route::livewire('categories', 'admin.control.categories.index')->name('admin.categories.index');
        Route::livewire('categories/create', 'admin.control.categories.create')->name('admin.categories.create');
        Route::livewire('categories/edit/{id}', 'admin.control.categories.edit')->name('admin.categories.edit');

        // Inheritance
        Route::livewire('inheritance', 'admin.control.inheritance.index')->name('admin.inheritance.index');
        Route::livewire('inheritance/create', 'admin.control.inheritance.create')->name('admin.inheritance.create');
        Route::livewire('inheritance/edit/{id}', 'admin.control.inheritance.edit')->name('admin.inheritance.edit');

        // Locations - Countries
        Route::livewire('countries', 'admin.control.locations.index')->name('admin.countries.index');
        Route::livewire('countries/create', 'admin.control.locations.create')->name('admin.countries.create');
        Route::livewire('countries/edit/{id}', 'admin.control.locations.edit')->name('admin.countries.edit');

        // Locations - Cities
        Route::livewire('cities', 'admin.control.locations.index')->name('admin.cities.index');
        Route::livewire('cities/create', 'admin.control.locations.create')->name('admin.cities.create');
        Route::livewire('cities/edit/{id}', 'admin.control.locations.edit')->name('admin.cities.edit');

        // Availability taxonomy
        Route::livewire('availabilities', 'admin.control.availability.index')->name('admin.availabilities.index');
        Route::livewire('availabilities/create', 'admin.control.availability.create')->name('admin.availabilities.create');
        Route::livewire('availabilities/edit/{id}', 'admin.control.availability.edit')->name('admin.availabilities.edit');

        // Admins
        Route::livewire('admins', 'admin.admins.index')->name('admin.admins.index');
        Route::livewire('admins/create', 'admin.admins.create')->name('admin.admins.create');
        Route::livewire('admins/edit/{id}', 'admin.admins.edit')->name('admin.admins.edit');

        // Members
        Route::livewire('members', 'admin.control.members.index')->name('admin.members.index');
        Route::livewire('members/edit/{id}', 'admin.control.members.edit')->name('admin.members.edit');

        // Securities
        Route::livewire('securities', 'admin.control.securities.index')->name('admin.securities.index');
        Route::livewire('securities/create', 'admin.control.securities.create')->name('admin.securities.create');
        Route::livewire('securities/edit/{id}', 'admin.control.securities.edit')->name('admin.securities.edit');

        // Orders
        Route::livewire('orders', 'admin.control.orders.index')->name('admin.orders.index');
        Route::livewire('trade-requests', 'admin.control.orders.index')->name('admin.trade-requests.index');
        Route::livewire('trade-logs', 'admin.control.trade-logs.index')->name('admin.trade-logs.index');
        Route::livewire('wallet-requests', 'admin.control.wallet-requests.index')->name('admin.wallet-requests.index');
        Route::livewire('wallet-till', 'admin.control.wallet-till.index')->name('admin.wallet-till.index');
        Route::livewire('transactions', 'admin.control.transactions.index')->name('admin.transactions.index');
        Route::get('transactions/{transaction}/receipt', AdminDownloadWalletReceiptController::class)->name('admin.transactions.receipt.download');
        Route::livewire('subscriptions', 'admin.control.subscriptions.index')->name('admin.subscriptions.index');
        Route::livewire('investment-portfolio', 'admin.control.investment-portfolio.index')->name('admin.investment-portfolio.index');
        Route::livewire('watchlists', 'admin.control.watchlists.index')->name('admin.watchlists.index');
        Route::livewire('community', 'admin.control.community.index')->name('admin.community.index');
        Route::livewire('community/create', 'admin.control.community.create')->name('admin.community.create');
        Route::livewire('community/{post}/edit', 'admin.control.community.edit')->name('admin.community.edit');
        Route::livewire('investment-packages', 'admin.control.investment-packages.index')->name('admin.investment-packages.index');
        Route::livewire('investment-packages/create', 'admin.control.investment-packages.create')->name('admin.investment-packages.create');
        Route::livewire('investment-packages/edit/{id}', 'admin.control.investment-packages.edit')->name('admin.investment-packages.edit');
        Route::livewire('investment-settings', 'admin.control.investment-settings.index')->name('admin.investment-settings.index');
        Route::livewire('notifications-settings', 'admin.control.notifications-settings.index')->name('admin.notifications-settings.index');

        // Currencies
        Route::prefix('atu/currencies')->name('admin.atu.currencies.')->group(function () {
            // Currencies
            Route::livewire('/', 'admin.atu.currencies.index')->name('index');
            Route::livewire('create', 'admin.atu.currencies.create')->name('create');
            Route::livewire('edit/{id}', 'admin.atu.currencies.edit')->name('edit');
            Route::livewire('settings', 'admin.atu.currencies.settings')->name('settings');
            Route::livewire('logs', 'admin.atu.currencies.logs')->name('logs');
        });
        // Email test routes (direct = SMTP, job = queue/cron)
        Route::get('test-email/direct', [TestEmailController::class, 'sendDirect'])->name('admin.test-email.direct');
        Route::get('test-email/job', [TestEmailController::class, 'sendViaJob'])->name('admin.test-email.job');
        Route::get('test-email/verification', [TestEmailController::class, 'sendVerificationEmail'])->name('admin.test-email.verification');

        // SMS Test Route
        Route::get('test-sms', function (\Illuminate\Http\Request $request) {
            $phone = $request->query('phone');
            $message = $request->query('message', 'This is a test message from Ziidi Trader.');

            if (! $phone) {
                return "Please provide a 'phone' parameter. Example: /admin/test-sms?phone=0712345678";
            }

            $success = app(\App\Services\Sms\SmsProvider::class)->send($phone, $message);

            return $success ? "SMS sent successfully to $phone" : "Failed to send SMS to $phone. Check logs for details.";
        })->name('admin.test-sms');
    });
});

require __DIR__.'/settings.php';
