<?php
    $wallet = auth()->check()
        ? \App\Models\Wallet::query()->firstOrCreate(
            ['user_id' => auth()->id()],
            ['currency_code' => app(\App\Services\DefaultCurrencyService::class)->code()]
        )
        : null;
    $user = auth()->user();
    $portfolioValue = $wallet ? (float) $wallet->available_balance : 0;
    $currencyCode = app(\App\Services\DefaultCurrencyService::class)->code();
?>
<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($wallet && $user): ?>
<aside class="hidden lg:flex flex-col w-72 min-h-screen fixed right-0 top-0 z-40 border-l border-border bg-card overflow-y-auto">
    <div class="p-5 space-y-6">
        
        <div class="flex items-center justify-end gap-3">
            <div class="text-right min-w-0">
                <p class="text-foreground text-sm font-semibold truncate"><?php echo e($user->name); ?></p>
                <p class="text-muted-foreground text-xs truncate"><?php echo e($user->email); ?></p>
            </div>
            <div class="w-9 h-9 bg-secondary rounded-full flex items-center justify-center shrink-0">
                <span class="text-xs font-bold text-foreground"><?php echo e(strtoupper(mb_substr($user->name, 0, 1))); ?></span>
            </div>
        </div>

        
        <div class="bg-secondary rounded-xl p-4">
            <div class="flex items-center gap-2 mb-2">
                <i class="fa-solid fa-briefcase h-4 w-4 text-muted-foreground"></i>
                <span class="text-muted-foreground text-xs font-medium"><?php echo e(__('Portfolio value')); ?></span>
            </div>
            <p class="text-foreground text-2xl font-bold">
                <?php echo e($currencyCode); ?> <?php echo e(number_format($portfolioValue, 2)); ?>

            </p>
            <p class="text-muted-foreground text-xs mt-1"><?php echo e(__('Available')); ?>: <?php echo e($currencyCode); ?> <?php echo e(number_format($wallet->available_balance, 2)); ?></p>
        </div>

        
        <div class="space-y-2">
            <a href="<?php echo e(route('member.mpesa-deposit')); ?>" wire:navigate
                class="flex items-center justify-center gap-2 w-full bg-primary text-primary-foreground font-semibold py-2.5 rounded-lg text-sm hover:opacity-90 transition-opacity">
                <i class="fa-solid fa-arrow-down-to-line h-4 w-4"></i>
                <?php echo e(__('Deposit')); ?>

            </a>
            <a href="<?php echo e(route('member.withdraw')); ?>" wire:navigate
                class="flex items-center justify-center gap-2 w-full bg-card text-foreground font-semibold py-2.5 rounded-lg text-sm border border-border hover:border-primary/30 transition-colors">
                <i class="fa-solid fa-arrow-up-from-line h-4 w-4"></i>
                <?php echo e(__('Withdraw')); ?>

            </a>
        </div>

        
        <div class="pt-2 border-t border-border space-y-1">
            <a href="<?php echo e(route('member.account')); ?>" wire:navigate
                class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm text-muted-foreground hover:bg-muted hover:text-foreground transition-colors">
                <i class="fa-solid fa-user h-4 w-4"></i>
                <?php echo e(__('Account')); ?>

            </a>
            <a href="<?php echo e(route('member.investments')); ?>" wire:navigate
                class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm text-muted-foreground hover:bg-muted hover:text-foreground transition-colors">
                <i class="fa-solid fa-sack-dollar h-4 w-4"></i>
                <?php echo e(__('Investments')); ?>

            </a>
            <a href="<?php echo e(route('member.trade')); ?>" wire:navigate
                class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm text-muted-foreground hover:bg-muted hover:text-foreground transition-colors">
                <i class="fa-solid fa-chart-line h-4 w-4"></i>
                <?php echo e(__('Trade')); ?>

            </a>
        </div>
    </div>
</aside>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
<?php /**PATH /home/ziidiaik/home.ziiditrader.com/resources/views/partials/trading/desktop-right-sidebar.blade.php ENDPATH**/ ?>