<?php
use App\Models\WalletTransaction;
use App\Services\DefaultCurrencyService;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithPagination;
?>

<div>
	<?php echo $__env->make('partials.trading.topbar', ['title' => 'Transactions'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

	<div class="space-y-3 px-4 py-4">
		<p class="text-sm font-semibold text-foreground"><?php echo e(__('Transaction')); ?></p>

		<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
			<div <?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processElementKey('transaction-{{ $transaction->id }}', get_defined_vars()); ?>wire:key="transaction-<?php echo e($transaction->id); ?>"
				class="flex items-center justify-between rounded-xl border border-border bg-card p-3">
				<div>
					<p class="text-sm font-semibold text-foreground"><?php echo e(ucfirst(str_replace('_', ' ', $transaction->type))); ?></p>
					<p class="text-xs text-muted-foreground"><?php echo e($transaction->created_at?->format('Y-m-d H:i')); ?></p>
				</div>
				<div class="text-right">
					<p class="text-sm font-semibold text-foreground"><?php echo e($this->currencyCode); ?>

						<?php echo e(number_format((float) $transaction->amount, 2)); ?></p>
					<?php ($normalizedStatus = strtolower((string) $transaction->status)); ?>
					<p
						class="text-xs text-muted-foreground transaction-status <?php echo e($normalizedStatus === 'pending' ? 'transaction-status--pending' : ($normalizedStatus === 'rejected' ? 'transaction-status--rejected' : (in_array($normalizedStatus, ['approved', 'completed'], true) ? 'transaction-status--approved' : ''))); ?>">
						<?php echo e(ucfirst($transaction->status)); ?>

					</p>
					<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->canDownloadReceipt($transaction)): ?>
						<a href="<?php echo e(route('member.transactions.receipt.print', ['transaction' => $transaction->id])); ?>"
							wire:navigate
							class="mt-2 inline-flex rounded-md border border-border px-2.5 py-1 text-xs font-semibold text-foreground hover:bg-muted/60">
							<?php echo e(__('Print receipt')); ?>

						</a>
					<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
				</div>
			</div>
		<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
			<p class="text-sm text-muted-foreground"><?php echo e(__('No transactions yet.')); ?></p>
		<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

		<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->transactions->hasPages()): ?>
			<div class="pt-1">
				<?php echo e($this->transactions->links()); ?>

			</div>
		<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
	</div>
</div><?php /**PATH /home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/7a3b1906.blade.php ENDPATH**/ ?>