<?php
use App\Models\Investment;
use App\Models\SecurityOrder;
use App\Models\Wallet;
use App\Models\WalletTransaction;
use App\Jobs\Vrm\SendMail;
use App\Mail\AdminTransactionMail;
use App\Services\DefaultCurrencyService;
use App\Services\MemberNotificationService;
use App\Services\Sms\SmsNotifier;
use App\Services\Trading\TradingSettingsService;
use App\Services\Vrm\InvestmentEmailService;
use App\Traits\Vrm\Livewire\WithNotifications;
use Illuminate\Support\Facades\DB;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
?>

<div>
    <?php echo $__env->make('partials.trading.topbar', ['title' => 'PORTFOLIO'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="px-4 pt-4">
        <?php echo $this->renderNotification(); ?>


        <div class="flex border-b border-border mb-4">
            <button
                type="button"
                wire:click="setTab('portfolio')"
                class="flex-1 pb-3 text-sm font-semibold transition-colors <?php echo e($activeTab === 'portfolio' ? 'text-foreground border-b-2 border-primary' : 'text-muted-foreground'); ?>"
            >
                <?php echo e(__('Portfolio')); ?>

            </button>
            <button
                type="button"
                wire:click="setTab('investments')"
                class="flex-1 pb-3 text-sm font-semibold transition-colors <?php echo e($activeTab === 'investments' ? 'text-foreground border-b-2 border-primary' : 'text-muted-foreground'); ?>"
            >
                <?php echo e(__('Investments')); ?>

            </button>
            <button
                type="button"
                wire:click="setTab('performance')"
                class="flex-1 pb-3 text-sm font-semibold transition-colors <?php echo e($activeTab === 'performance' ? 'text-foreground border-b-2 border-primary' : 'text-muted-foreground'); ?>"
            >
                <?php echo e(__('Performance')); ?>

            </button>
        </div>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($activeTab === 'portfolio'): ?>
            <div class="space-y-4">
                <div class="bg-card rounded-xl p-5 border border-border">
                    <p class="text-muted-foreground text-sm mb-1"><?php echo e(__('Your portfolio value')); ?></p>
                    <h2 class="text-md font-bold text-foreground mb-3"><?php echo e($this->portfolio['currency']); ?> <?php echo e(number_format($this->portfolio['balance'], 2)); ?></h2>
                    <div class="border-t border-border pt-3 flex items-center justify-between">
                        <span class="text-muted-foreground text-sm"><?php echo e(__('Value')); ?> : <?php echo e($this->portfolio['currency']); ?> <?php echo e(number_format($this->portfolio['balance'] + $this->portfolio['inTrade'], 2)); ?></span>
                        <span class="text-sm font-semibold px-4 py-1 rounded-full <?php echo e($this->portfolio['gainLoss'] >= 0 ? 'bg-primary text-primary-foreground' : 'bg-destructive text-destructive-foreground'); ?>">
                            <?php echo e($this->portfolio['gainLoss'] >= 0 ? '+' : ''); ?><?php echo e(number_format($this->portfolio['gainLoss'], 2)); ?>%
                        </span>
                    </div>
                </div>

                <?php
                    $activeSellHolding = $this->selectedSellHolding();
                ?>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sellStep === 'list'): ?>
                    <div class="bg-card rounded-xl border border-border overflow-hidden">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->visibleHoldings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $holding): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                            <div class="px-4 py-4 border-t border-border space-y-3 first:border-t-0" <?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processElementKey('holding-{{ $holding[\'id\'] }}', get_defined_vars()); ?>wire:key="holding-<?php echo e($holding['id']); ?>">
                                <div class="flex items-start justify-between gap-3">
                                    <div>
                                        <p class="text-foreground font-semibold text-sm"><?php echo e($holding['symbol']); ?></p>
                                        <p class="text-muted-foreground text-xs"><?php echo e($holding['name']); ?></p>
                                        <p class="text-muted-foreground text-xs mt-0.5"><?php echo e(__('First invested')); ?>: <?php echo e($holding['firstInvestedAt']); ?></p>
                                    </div>
                                    <div class="text-right">
                                        <p class="text-foreground text-sm font-semibold"><?php echo e($this->portfolio['currency']); ?> <?php echo e(number_format($holding['value'], 2)); ?></p>
                                        <p class="text-xs text-muted-foreground"><?php echo e(__('Current Value')); ?></p>
                                    </div>
                                </div>
                                <div class="grid grid-cols-2 gap-2 text-xs">
                                    <div>
                                        <p class="text-muted-foreground"><?php echo e(__('Performance')); ?></p>
                                        <p class="font-semibold <?php echo e($holding['performancePercent'] >= 0 ? 'text-gain' : 'text-loss'); ?>">
                                            <?php echo e($holding['performancePercent'] >= 0 ? '+' : ''); ?><?php echo e(number_format($holding['performancePercent'], 2)); ?>%
                                        </p>
                                    </div>
                                    <div class="text-right">
                                        <p class="text-muted-foreground"><?php echo e(__('Available to Sell')); ?></p>
                                        <p class="font-semibold text-foreground"><?php echo e($holding['available_quantity']); ?></p>
                                    </div>
                                </div>
                                <p class="text-xs text-muted-foreground">
                                    <?php echo e(__('Since Invested')); ?>:
                                    <span class="<?php echo e($holding['performanceAmount'] >= 0 ? 'text-gain' : 'text-loss'); ?>">
                                        <?php echo e($holding['performanceAmount'] >= 0 ? '+' : ''); ?><?php echo e($this->portfolio['currency']); ?> <?php echo e(number_format(abs($holding['performanceAmount']), 2)); ?>

                                    </span>
                                </p>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($holding['available_quantity'] > 0): ?>
                                    <button
                                        type="button"
                                        wire:click="startSellFlow(<?php echo e($holding['id']); ?>)"
                                        class="w-full rounded-md bg-primary px-3 py-2 text-sm font-semibold text-primary-foreground"
                                    >
                                        <?php echo e(__('Sell')); ?>

                                    </button>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                            <div class="px-4 py-8 text-center text-sm text-muted-foreground"><?php echo e(__('No holdings yet.')); ?></div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->hasMoreHoldings): ?>
                            <div class="px-4 py-4 border-t border-border">
                                <button
                                    type="button"
                                    wire:click="showMoreHoldings"
                                    class="w-full rounded-md border border-border bg-background px-3 py-2 text-sm font-semibold text-foreground"
                                >
                                    <?php echo e(__('Show More')); ?>

                                </button>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sellStep === 'details' && $activeSellHolding): ?>
                    <?php
                        $sellHolding = $activeSellHolding;
                    ?>
                    <div class="bg-card rounded-xl border border-border p-4 space-y-4">
                        <p class="text-sm font-semibold text-foreground"><?php echo e(__('Sell :symbol Shares', ['symbol' => $sellHolding['symbol']])); ?></p>
                        <div class="text-xs space-y-1">
                            <p class="text-muted-foreground"><?php echo e($sellHolding['name']); ?></p>
                            <p class="text-muted-foreground"><?php echo e(__('Available shares')); ?>: <?php echo e($sellHolding['available_quantity']); ?></p>
                            <p class="text-muted-foreground"><?php echo e(__('Current price')); ?>: Ksh <?php echo e(number_format((float) $sellHolding['price'], 2)); ?></p>
                        </div>
                        <div>
                            <label class="block text-xs font-medium text-muted-foreground mb-1"><?php echo e(__('Shares to Sell')); ?></label>
                            <input
                                type="number"
                                min="<?php echo e(max(1, (int) ($this->sellLimits['min_per_request'] ?? 1))); ?>"
                                max="<?php echo e(max(1, $this->sellMaxAllowedForHolding((int) $sellHolding['id']))); ?>"
                                step="1"
                                wire:model.live.debounce.250ms="sellShares"
                                class="w-full rounded-md border border-border bg-background px-3 py-2 text-sm text-foreground"
                            />
                            <p class="mt-1 text-xs text-muted-foreground">
                                <?php echo e(__('Min :min • Max :max', ['min' => (int) ($this->sellLimits['min_per_request'] ?? 1), 'max' => (int) ($this->sellLimits['max_per_request'] ?? 0) > 0 ? number_format((int) $this->sellLimits['max_per_request']) : __('No limit')])); ?>

                            </p>
                            <p class="text-xs text-muted-foreground">
                                <?php echo e(__('Daily remaining shares')); ?>:
                                <?php echo e((int) ($this->sellLimits['max_per_day'] ?? 0) > 0 ? number_format($this->sellRemainingDailyShares) : __('No limit')); ?>

                            </p>
                        </div>
                        <div>
                            <label class="block text-xs font-medium text-muted-foreground mb-1"><?php echo e(__('Estimated Amount (Ksh)')); ?></label>
                            <input
                                type="text"
                                readonly
                                value="Ksh <?php echo e(number_format($this->sellPreviewAmount(), 2)); ?>"
                                class="w-full rounded-md border border-border bg-muted/30 px-3 py-2 text-sm font-semibold text-foreground cursor-not-allowed"
                            />
                        </div>
                        <div class="grid grid-cols-2 gap-2">
                            <button type="button" wire:click="resetSellFlow" class="w-full rounded-md border border-border bg-background px-4 py-2 text-sm font-semibold text-foreground"><?php echo e(__('Back')); ?></button>
                            <button type="button" wire:click="goToSellConfirmation" class="w-full rounded-md bg-primary px-4 py-2 text-sm font-semibold text-primary-foreground"><?php echo e(__('Continue')); ?></button>
                        </div>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sellStep === 'confirm' && $activeSellHolding): ?>
                    <?php
                        $sellHolding = $activeSellHolding;
                    ?>
                    <div class="bg-card rounded-xl border border-border p-4 space-y-4">
                        <p class="text-sm font-semibold text-foreground"><?php echo e(__('Confirm Sell Request')); ?></p>
                        <div class="text-sm space-y-1">
                            <p class="text-foreground font-semibold"><?php echo e($sellHolding['symbol']); ?> - <?php echo e($sellHolding['name']); ?></p>
                            <p class="text-muted-foreground"><?php echo e(__('Shares')); ?>: <?php echo e((int) $sellShares); ?></p>
                            <p class="text-muted-foreground"><?php echo e(__('Estimated payout')); ?>: Ksh <?php echo e(number_format($this->sellPreviewAmount(), 2)); ?></p>
                        </div>
                        <div class="grid grid-cols-2 gap-2">
                            <button type="button" wire:click="backToSellDetails" class="w-full rounded-md border border-border bg-background px-4 py-2 text-sm font-semibold text-foreground"><?php echo e(__('Edit')); ?></button>
                            <button type="button" wire:click="submitSellRequest" class="w-full rounded-md bg-primary px-4 py-2 text-sm font-semibold text-primary-foreground"><?php echo e(__('Confirm')); ?></button>
                        </div>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sellStep === 'result'): ?>
                    <div class="bg-card rounded-xl border border-border p-4 space-y-4 text-center">
                        <div class="mx-auto size-12 rounded-full bg-primary text-primary-foreground flex items-center justify-center">
                            <i class="fa-solid fa-check"></i>
                        </div>
                        <p class="text-sm font-semibold text-foreground"><?php echo e(__('Sell Request Submitted')); ?></p>
                        <p class="text-sm text-muted-foreground"><?php echo e(__('The request will be completed.')); ?></p>
                        <p class="text-xs text-muted-foreground"><?php echo e($sellSubmittedSymbol); ?> • <?php echo e(__('Qty')); ?>: <?php echo e($sellSubmittedShares); ?> • Ksh <?php echo e(number_format($sellSubmittedAmount, 2)); ?></p>
                        <button type="button" wire:click="resetSellFlow" class="w-full rounded-md bg-primary px-4 py-2 text-sm font-semibold text-primary-foreground"><?php echo e(__('Done')); ?></button>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($activeTab === 'investments'): ?>
            <div class="space-y-4">
                <p class="text-sm text-muted-foreground"><?php echo e(__('Your investment subscriptions and progress.')); ?></p>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->subscriptionInvestments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                    <?php
                        $isMatured = $inv->matures_at->isPast();
                        $progressPercent = $inv->duration_hours ? min(100, (int) round($inv->progress_ratio * 100)) : 0;
                    ?>
                    <div class="bg-card rounded-xl p-4 border border-border space-y-3" <?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processElementKey('inv-{{ $inv->id }}', get_defined_vars()); ?>wire:key="inv-<?php echo e($inv->id); ?>">
                        <div class="flex items-start justify-between gap-3">
                            <div>
                                <p class="text-foreground font-semibold text-sm"><?php echo e($inv->package?->name ?? __('Investment')); ?></p>
                                <p class="text-xs text-muted-foreground"><?php echo e($this->portfolio['currency']); ?> <?php echo e(number_format((float) $inv->principal_amount, 2)); ?> → <?php echo e($this->portfolio['currency']); ?> <?php echo e(number_format((float) $inv->expected_return_amount, 2)); ?></p>
                                <p class="text-xs text-muted-foreground"><?php echo e(__('Matures')); ?>: <?php echo e($inv->matures_at->format('Y-m-d H:i')); ?></p>
                            </div>
                            <span class="text-xs px-2 py-0.5 rounded-full <?php echo e($isMatured ? 'bg-primary/20 text-primary' : 'investment-status--active'); ?>">
                                <?php echo e($isMatured ? __('Matured') : __('Active')); ?>

                            </span>
                        </div>
                        <div>
                            <div class="flex justify-between text-xs text-muted-foreground mb-1">
                                <span><?php echo e(__('Accrued')); ?>: <?php echo e($this->portfolio['currency']); ?> <?php echo e(number_format($inv->accrued_amount, 2)); ?></span>
                                <span class="font-semibold text-emerald-700"><?php echo e($progressPercent); ?>%</span>
                            </div>
                            <div class="h-4 rounded-sm border border-emerald-600 bg-white overflow-hidden">
                                <div
                                    class="h-full transition-all bg-[repeating-linear-gradient(135deg,theme(colors.emerald.600)_0_8px,white_8px_16px)]"
                                    style="width: <?php echo e($progressPercent); ?>%"
                                ></div>
                            </div>
                        </div>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($isMatured): ?>
                            <button type="button" wire:click="$js.confirmClaimReturn(<?php echo e($inv->id); ?>)"
                                class="w-full rounded-md bg-primary px-3 py-2 text-sm font-semibold text-primary-foreground">
                                <?php echo e(__('Claim Return')); ?>

                            </button>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                    <div class="px-4 py-8 text-center text-sm text-muted-foreground"><?php echo e(__('No investment subscriptions yet.')); ?></div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($activeTab === 'performance'): ?>
            <div class="space-y-3">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->holdings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $holding): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                    <?php
                        $barWidth = min(abs($holding['performancePercent']) * 2, 100);
                    ?>
                    <div class="bg-card rounded-xl p-4 border border-border" <?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processElementKey('perf-{{ $holding[\'id\'] }}', get_defined_vars()); ?>wire:key="perf-<?php echo e($holding['id']); ?>">
                        <div class="flex items-center justify-between mb-2">
                            <div>
                                <p class="text-foreground font-semibold text-sm"><?php echo e($holding['symbol']); ?></p>
                                <p class="text-muted-foreground text-xs"><?php echo e($holding['name']); ?></p>
                            </div>
                            <div class="text-right">
                                <p class="text-foreground font-semibold text-sm"><?php echo e($this->portfolio['currency']); ?> <?php echo e(number_format($holding['value'], 2)); ?></p>
                                <span class="text-xs font-medium <?php echo e($holding['performancePercent'] >= 0 ? 'text-gain' : 'text-loss'); ?>">
                                    <?php echo e($holding['performancePercent'] >= 0 ? '+' : ''); ?><?php echo e(number_format($holding['performancePercent'], 2)); ?>%
                                </span>
                            </div>
                        </div>
                        <div class="bg-secondary rounded-full h-2 overflow-hidden">
                            <div class="h-full rounded-full <?php echo e($holding['performancePercent'] >= 0 ? 'bg-gain' : 'bg-loss'); ?>" style="width: <?php echo e($barWidth); ?>%"></div>
                        </div>
                        <p class="text-xs text-muted-foreground mt-2"><?php echo e(__('Since invested')); ?>: <?php echo e($holding['performanceAmount'] >= 0 ? '+' : ''); ?><?php echo e($this->portfolio['currency']); ?> <?php echo e(number_format(abs($holding['performanceAmount']), 2)); ?></p>
                    </div>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                    <div class="px-4 py-8 text-center text-sm text-muted-foreground"><?php echo e(__('No performance data yet.')); ?></div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>

        <?php
        $__scriptKey = '623222063-0';
        ob_start();
    ?>
        <script>
            $js('confirmClaimReturn', async (investmentId) => {
                const result = await Swal.fire({
                    title: 'Claim investment return?',
                    text: 'This will move the matured return into your wallet.',
                    icon: 'question',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, claim now',
                });

                if (!result.isConfirmed) {
                    return;
                }

                await $wire.claimInvestment(investmentId);
            });
        </script>
        <?php
        $__output = ob_get_clean();

        \Livewire\store($this)->push('scripts', $__output, $__scriptKey)
    ?>
</div><?php /**PATH /home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/eef99a17.blade.php ENDPATH**/ ?>