<?php
use App\Models\Investment;
use App\Models\InvestmentPackage;
use App\Models\Wallet;
use App\Jobs\Vrm\SendMail;
use App\Mail\AdminTransactionMail;
use App\Services\DefaultCurrencyService;
use App\Services\Investment\SubscriptionService;
use App\Services\Sms\SmsAfrikasTalking;
use App\Services\Vrm\InvestmentEmailService;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
?>

<div>
    <?php echo $__env->make('partials.trading.topbar', ['title' => 'INVESTMENTS'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="px-4 py-4 space-y-4">
        <?php echo $this->renderNotification(); ?>


        <div class="bg-primary/10 text-white rounded-xl p-4 border border-primary/20 space-y-2">
            <p class="text-sm text-white/80"><?php echo e(__('Available Balance')); ?></p>
            <p class="text-md font-bold text-white"><?php echo e($this->currencyCode); ?> <?php echo e(number_format($this->wallet->available_balance, 2)); ?></p>
        </div>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->packages->isNotEmpty()): ?>
            <div class="space-y-3">
                <h2 class="text-base font-semibold text-foreground"><?php echo e(__('Available Packages')); ?></h2>

                <div class="relative">
                    <i class="fa-solid fa-search absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 text-muted-foreground"></i>
                    <input
                        type="text"
                        wire:model.live.debounce.300ms="search"
                        placeholder="<?php echo e(__('Search packages...')); ?>"
                        class="w-full bg-card border border-border rounded-lg py-3 pl-11 pr-4 text-foreground placeholder:text-muted-foreground focus:outline-none focus:ring-2 focus:ring-primary"
                    />
                </div>

                <div class="space-y-2">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->filteredPackages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pkg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                        <?php
                            $isSelected = (string) $pkg->id === $selectedPackageId;
                        ?>
                        <button
                            type="button"
                            <?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processElementKey('package-{{ $pkg->id }}', get_defined_vars()); ?>wire:key="package-<?php echo e($pkg->id); ?>"
                            wire:click="choosePackage(<?php echo e($pkg->id); ?>)"
                            class="w-full bg-card rounded-xl px-3 py-3 border text-left transition-colors <?php echo e($isSelected ? 'border-primary ring-1 ring-primary/40' : 'border-border hover:border-primary/30'); ?>"
                        >
                            <div class="flex items-start justify-between gap-3">
                                <div class="flex items-start gap-3 min-w-0">
                                    <div class="w-10 h-10 bg-secondary rounded-full flex items-center justify-center shrink-0 overflow-hidden">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(! empty($pkg->photo)): ?>
                                            <img src="<?php echo e(asset($pkg->photo)); ?>" alt="" class="size-10 rounded-full object-cover" />
                                        <?php else: ?>
                                            <span class="text-xs font-bold text-foreground"><?php echo e(strtoupper(substr($pkg->name, 0, 2))); ?></span>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                    <div class="min-w-0">
                                        <p class="text-foreground font-bold text-sm truncate"><?php echo e($pkg->name); ?></p>
                                        <p class="text-xs text-muted-foreground">
                                            <?php echo e(__('Min')); ?> <?php echo e($this->currencyCode); ?> <?php echo e(number_format((float) $pkg->min_amount, 2)); ?>

                                            •
                                            <?php echo e(__('Max')); ?> <?php echo e($this->currencyCode); ?> <?php echo e(number_format((float) $pkg->max_amount, 2)); ?>

                                        </p>
                                        <p class="text-xs text-muted-foreground">
                                            <?php echo e($pkg->duration_hours); ?><?php echo e(__('h')); ?> • <?php echo e(number_format((float) $pkg->interest_percent, 1)); ?>%
                                        </p>
                                    </div>
                                </div>

                                <div class="text-right shrink-0">
                                    <span class="inline-flex items-center rounded-full px-3 py-1 text-xs font-semibold transition-colors <?php echo e($isSelected ? 'bg-primary text-primary-foreground' : 'bg-primary/10 text-primary'); ?>">
                                        <i class="fa-solid fa-hand-pointer mr-1 text-[10px]"></i>
                                        <?php echo e(__('Invest')); ?>

                                    </span>
                                    <p class="text-xs text-muted-foreground"><?php echo e(__('Tap to select')); ?></p>
                                </div>
                            </div>
                        </button>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                        <p class="text-sm text-muted-foreground"><?php echo e(__('No packages found for your search.')); ?></p>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->selectedPackage): ?>
                    <?php
                        $pkg = $this->selectedPackage;
                    ?>
                    <div class="bg-card rounded-xl p-4 border border-border space-y-3">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($investStep === 'amount'): ?>
                            <h3 class="text-sm font-semibold text-foreground"><?php echo e(__('Invest in :name', ['name' => $pkg->name])); ?></h3>
                            <div>
                                <label class="required block text-xs font-medium text-muted-foreground mb-1"><?php echo e(__('Amount')); ?></label>
                                <input type="number" step="0.01" min="<?php echo e($pkg->min_amount); ?>" max="<?php echo e($pkg->max_amount); ?>" wire:model.live.debounce.250ms="amount"
                                    class="w-full rounded-md border border-border bg-background px-3 py-2 text-sm" placeholder="<?php echo e(number_format((float) $pkg->min_amount, 2)); ?>" />
                                <p class="text-xs text-muted-foreground mt-1"><?php echo e(__('Min :min – Max :max', ['min' => number_format((float) $pkg->min_amount, 2), 'max' => number_format((float) $pkg->max_amount, 2)])); ?> <?php echo e($this->currencyCode); ?></p>
                                <span class="text-destructive text-xs"><?php echo e($errors->first('amount')); ?></span>
                            </div>

                            <div class="rounded-lg border border-border bg-background px-3 py-2 text-sm text-muted-foreground">
                                <p><?php echo e(__('Duration')); ?>: <span class="font-semibold text-foreground"><?php echo e($pkg->duration_hours); ?> <?php echo e(__('hours')); ?></span></p>
                                <p><?php echo e(__('Expected Return')); ?>: <span class="font-semibold text-foreground"><?php echo e($this->currencyCode); ?> <?php echo e(number_format($this->expectedReturnPreview, 2)); ?></span></p>
                            </div>

                            <button type="button" wire:click="goToInvestConfirmation"
                                class="w-full rounded-md bg-primary px-4 py-2 text-sm font-semibold text-primary-foreground">
                                <?php echo e(__('Continue')); ?>

                            </button>
                        <?php elseif($investStep === 'confirm'): ?>
                            <div class="rounded-2xl border border-border bg-background p-4 space-y-4">
                                <div class="flex justify-center">
                                    <div class="size-16 rounded-full bg-green-600 text-white flex items-center justify-center">
                                        <i class="fa-solid fa-chart-line text-xl"></i>
                                    </div>
                                </div>
                                <p class="text-center text-lg font-black text-foreground uppercase"><?php echo e(__('Invest to :name', ['name' => config('app.name')])); ?></p>
                                <div class="text-center">
                                    <p class="text-xl font-black text-foreground"><?php echo e(__('Amount')); ?>: <?php echo e(number_format((float) $amount, 2)); ?></p>
                                    <p class="text-muted-foreground text-sm"><?php echo e(__('Transaction Fee: :currency :fee', ['currency' => $this->currencyCode, 'fee' => number_format(0, 2)])); ?></p>
                                </div>
                            </div>
                            <div class="flex gap-2">
                                <button type="button" wire:click="backToInvestAmount"
                                    class="flex-1 rounded-md border border-border bg-background px-4 py-2 text-sm font-semibold text-foreground">
                                    <?php echo e(__('Edit')); ?>

                                </button>
                                <button type="button" wire:click="confirmInvestment"
                                    class="flex-1 rounded-md bg-primary px-4 py-2 text-sm font-semibold text-primary-foreground">
                                    <?php echo e(__('Invest')); ?>

                                </button>
                            </div>
                        <?php else: ?>
                            <div class="rounded-2xl border border-border bg-background p-5 text-center space-y-5">
                                <div class="mx-auto size-16 rounded-full flex items-center justify-center <?php echo e($investResultStatus === 'failed' ? 'bg-destructive/20 text-destructive' : 'bg-green-100 text-green-600'); ?>">
                                    <i class="fa-solid <?php echo e($investResultStatus === 'failed' ? 'fa-xmark' : ($investResultStatus === 'pending' ? 'fa-hourglass-half' : 'fa-check')); ?> text-xl"></i>
                                </div>
                                <div class="space-y-1">
                                    <p class="text-lg font-black text-foreground uppercase">
                                        <?php echo e($investResultPackageName !== '' ? __('Invest to :name', ['name' => $investResultPackageName]) : __('Investment')); ?>

                                    </p>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($investResultAmount > 0): ?>
                                        <p class="text-xl font-black text-foreground"><?php echo e(__('Amount')); ?>: <?php echo e(number_format($investResultAmount, 2)); ?></p>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    <p class="text-sm text-muted-foreground"><?php echo e(__('Transaction Fee: :currency :fee', ['currency' => $this->currencyCode, 'fee' => number_format(0, 2)])); ?></p>
                                </div>
                                <p class="<?php echo e($investResultStatus === 'failed' ? 'text-destructive' : 'text-green-600'); ?> text-lg font-medium">
                                    <?php echo e($investResultMessage !== '' ? $investResultMessage : __('Your request has been received. Kindly wait for confirmation.')); ?>

                                </p>
                                <button type="button" wire:click="finishInvestmentFlow"
                                    class="w-full rounded-md bg-primary px-4 py-2 text-sm font-semibold text-primary-foreground">
                                    <?php echo e(__('Done')); ?>

                                </button>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        <?php else: ?>
            <p class="text-sm text-muted-foreground"><?php echo e(__('No investment packages available at the moment.')); ?></p>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <div class="space-y-2">
            <h3 class="text-sm font-semibold text-foreground"><?php echo e(__('Your Investments')); ?></h3>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->investments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                <?php
                    $isMatured = $investment->status === 'active' && $investment->matures_at->isPast();
                    $statusClass = match (strtolower((string) $investment->status)) {
                        'active' => 'bg-emerald-900/20 text-emerald-600',
                        'claimed' => 'bg-secondary text-muted-foreground',
                        default => 'bg-secondary text-muted-foreground',
                    };
                ?>
                <div class="bg-card rounded-xl p-3 border border-border space-y-2" <?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processElementKey('investment-{{ $investment->id }}', get_defined_vars()); ?>wire:key="investment-<?php echo e($investment->id); ?>">
                    <div class="flex items-start justify-between gap-3">
                        <div>
                            <p class="text-sm font-semibold text-foreground">
                                <?php echo e($investment->package?->name ?? __('Investment')); ?>:
                                <?php echo e($this->currencyCode); ?> <?php echo e(number_format((float) $investment->principal_amount, 2)); ?>

                                <span class="text-muted-foreground">→</span>
                                <?php echo e($this->currencyCode); ?> <?php echo e(number_format((float) $investment->expected_return_amount, 2)); ?>

                            </p>
                            <p class="text-xs text-muted-foreground">
                                <?php echo e(__('Matures')); ?>: <?php echo e($investment->matures_at->format('Y-m-d H:i')); ?>

                            </p>
                        </div>
                        <span class="text-xs px-2 py-0.5 rounded-full <?php echo e($isMatured ? 'bg-primary/20 text-primary' : $statusClass); ?>">
                            <?php echo e($isMatured ? __('Matured') : ucfirst($investment->status)); ?>

                        </span>
                    </div>

                </div>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                <p class="text-sm text-muted-foreground"><?php echo e(__('No investments yet.')); ?></p>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>

</div><?php /**PATH /home/ziidiaik/home.ziiditrader.com/storage/framework/views/livewire/views/edd15e8f.blade.php ENDPATH**/ ?>