<?php
use App\Models\PortfolioHolding;
use App\Models\Security;
use App\Models\SecurityOrder;
use App\Models\SecurityWatchlist;
use App\Models\Wallet;
use App\Models\WalletTransaction;
use App\Services\Trading\TradingSettingsService;
use App\Traits\Vrm\Livewire\WithNotifications;
use Illuminate\Support\Facades\DB;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
?>

<div>
    <?php echo $__env->make('partials.trading.topbar', ['title' => 'TRADE'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="px-4 space-y-4">
        <?php echo $this->renderNotification(); ?>


        <div class="bg-card rounded-lg p-3 border border-border text-sm text-foreground">
            <?php echo e(__('Available Balance')); ?>: <?php echo e($this->wallet->currency_code); ?> <?php echo e(number_format($this->wallet->available_balance, 2)); ?>

        </div>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(! $this->isMarketOpen): ?>
            <div class="rounded-lg border border-red-300 bg-red-50 px-3 py-2 text-sm text-red-700 dark:border-red-700 dark:bg-red-900/20 dark:text-red-300">
                <?php echo e(__('Market is closed for today.')); ?>

            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <div class="relative">
            <i class="fa-solid fa-search absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 text-muted-foreground"></i>
            <input
                type="text"
                wire:model.live.debounce.300ms="search"
                placeholder="<?php echo e(__('What are you looking for today?')); ?>"
                class="w-full bg-card border border-border rounded-lg py-3 pl-11 pr-4 text-foreground placeholder:text-muted-foreground focus:outline-none focus:ring-2 focus:ring-primary"
            />
        </div>

        <div>
            <h2 class="text-foreground font-semibold mb-3"><?php echo e($showWatchlist ? __('My Watchlist') : __('Available Securities')); ?></h2>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(! $showWatchlist): ?>
                <div class="flex gap-2 overflow-x-auto pb-2">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = ['All', 'Gainers', 'Losers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                        <button
                            type="button"
                            wire:click="setFilter('<?php echo e($f); ?>')"
                            class="px-4 py-1.5 rounded-full text-sm font-medium whitespace-nowrap border transition-colors <?php echo e($activeFilter === $f ? 'bg-primary text-primary-foreground border-primary' : 'bg-card text-muted-foreground border-border hover:border-primary/50'); ?>"
                        >
                            <?php echo e($f); ?>

                        </button>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>

        <div class="space-y-2">
            <?php
                $displayList = $showWatchlist ? $this->watchlistSecurities : $this->filteredSecurities;
            ?>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $displayList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $security): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                <?php
                    $change = $security->latestChangePercent();
                    $isWatched = in_array($security->id, $this->watchlistIds, true);
                    $isSelected = $selectedSecurityId === $security->id;
                ?>
                <div
                    <?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processElementKey('trade-{{ $security->id }}', get_defined_vars()); ?>wire:key="trade-<?php echo e($security->id); ?>"
                    wire:click="selectSecurity(<?php echo e($security->id); ?>)"
                    class="w-full bg-card rounded-xl p-4 border space-y-3 text-left transition-colors cursor-pointer <?php echo e($isSelected ? 'border-primary' : 'border-border hover:border-primary/30'); ?>"
                >
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-secondary rounded-full flex items-center justify-center shrink-0">
                            <span class="text-xs font-bold text-foreground"><?php echo e(substr($security->trading_name, 0, 2)); ?></span>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-foreground font-bold text-sm"><?php echo e($security->trading_name); ?></p>
                            <p class="text-muted-foreground text-xs truncate"><?php echo e($security->name); ?></p>
                        </div>
                        <button type="button" wire:click.stop="toggleSecurityWatchlist(<?php echo e($security->id); ?>)" class="text-sm <?php echo e($isWatched ? 'text-yellow-500' : 'text-muted-foreground'); ?>">
                            <i class="fa-solid fa-star"></i>
                        </button>
                    </div>

                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-foreground font-bold text-sm"><?php echo e($security->currency_code); ?> <?php echo e(number_format((float) $security->current_amount, 2)); ?></p>
                            <span class="text-xs font-medium <?php echo e($change >= 0 ? 'text-gain' : 'text-loss'); ?>">
                                <?php echo e($change >= 0 ? '+' : ''); ?><?php echo e(number_format($change, 2)); ?>%
                            </span>
                        </div>

                        <span class="rounded-md px-3 py-1.5 text-xs font-semibold bg-secondary text-foreground">
                            <?php echo e(__('View')); ?>

                        </span>
                    </div>
                </div>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                <p class="text-center text-sm text-muted-foreground py-6"><?php echo e(__('No securities available.')); ?></p>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->selectedSecurity): ?>
            <?php
                $selected = $this->selectedSecurity;
                $holding = $this->selectedHolding;
                $buyAmount = (float) ($orderAmounts[$selected->id] ?? 0);
                $buyQtyPreview = $buyAmount > 0 ? (int) floor($buyAmount / (float) $selected->current_amount) : 0;
                $change = $selected->latestChangePercent();
            ?>

            <div class="bg-card rounded-xl border border-primary/40 p-4 space-y-4" <?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processElementKey('selected-security-{{ $selected->id }}', get_defined_vars()); ?>wire:key="selected-security-<?php echo e($selected->id); ?>">
                <div class="flex items-start justify-between gap-3">
                    <div>
                        <p class="text-foreground text-base font-bold"><?php echo e($selected->trading_name); ?> - <?php echo e($selected->name); ?></p>
                        <p class="text-sm text-muted-foreground">
                            <?php echo e($selected->currency_code); ?> <?php echo e(number_format((float) $selected->current_amount, 2)); ?>

                            <span class="ml-2 <?php echo e($change >= 0 ? 'text-gain' : 'text-loss'); ?>"><?php echo e($change >= 0 ? '+' : ''); ?><?php echo e(number_format($change, 2)); ?>%</span>
                        </p>
                    </div>
                    <span class="text-xs rounded-full px-2 py-1 bg-secondary text-muted-foreground"><?php echo e(__('Selected')); ?></span>
                </div>

                <div class="grid grid-cols-2 gap-3 text-sm">
                    <div class="rounded-lg border border-border p-3">
                        <p class="text-xs text-muted-foreground"><?php echo e(__('Shares Owned')); ?></p>
                        <p class="font-semibold text-foreground"><?php echo e($holding['quantity']); ?></p>
                    </div>
                    <div class="rounded-lg border border-border p-3">
                        <p class="text-xs text-muted-foreground"><?php echo e(__('Available to Sell')); ?></p>
                        <p class="font-semibold text-foreground"><?php echo e($holding['available_quantity']); ?></p>
                    </div>
                    <div class="rounded-lg border border-border p-3">
                        <p class="text-xs text-muted-foreground"><?php echo e(__('Invested')); ?></p>
                        <p class="font-semibold text-foreground"><?php echo e($selected->currency_code); ?> <?php echo e(number_format($holding['total_invested'], 2)); ?></p>
                    </div>
                    <div class="rounded-lg border border-border p-3">
                        <p class="text-xs text-muted-foreground"><?php echo e(__('Current Value')); ?></p>
                        <p class="font-semibold text-foreground"><?php echo e($selected->currency_code); ?> <?php echo e(number_format($holding['current_value'], 2)); ?></p>
                    </div>
                </div>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($holding['quantity'] > 0): ?>
                    <div class="rounded-lg border border-border bg-background px-3 py-2 text-sm">
                        <p class="text-muted-foreground"><?php echo e(__('Performance')); ?></p>
                        <p class="font-semibold <?php echo e($holding['gain_loss_percent'] >= 0 ? 'text-gain' : 'text-loss'); ?>">
                            <?php echo e($holding['gain_loss_percent'] >= 0 ? '+' : ''); ?><?php echo e(number_format($holding['gain_loss_percent'], 2)); ?>% (<?php echo e($selected->currency_code); ?> <?php echo e(number_format($holding['gain_loss_amount'], 2)); ?>)
                        </p>
                    </div>
                <?php else: ?>
                    <p class="text-sm text-muted-foreground"><?php echo e(__('You have not purchased this security yet.')); ?></p>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <div class="space-y-3 rounded-lg border border-border p-3">
                    <p class="text-sm font-semibold text-foreground"><?php echo e(__('Buy Security')); ?></p>
                    <div class="space-y-2">
                        <label class="block text-xs text-muted-foreground"><?php echo e(__('Amount to invest')); ?></label>
                        <input type="number" min="0.01" step="0.01" wire:model="orderAmounts.<?php echo e($selected->id); ?>" placeholder="0.00"
                            class="w-full rounded-md border border-border bg-background px-3 py-2 text-sm" />
                        <p class="text-xs text-muted-foreground"><?php echo e(__('Estimated shares')); ?>: <span class="font-semibold text-foreground"><?php echo e(max(0, $buyQtyPreview)); ?></span></p>
                    </div>
                    <button type="button" wire:click="placeBuyOrder(<?php echo e($selected->id); ?>)"
                        <?php if(! $this->isMarketOpen): echo 'disabled'; endif; ?>
                        class="w-full rounded-md px-3 py-2 text-sm font-semibold <?php echo e($this->isMarketOpen ? 'bg-primary text-primary-foreground' : 'cursor-not-allowed bg-gray-400 text-white'); ?>">
                        <?php echo e(__('Submit Buy Request')); ?>

                    </button>
                </div>

                <div class="space-y-3 rounded-lg border border-border p-3">
                    <p class="text-sm font-semibold text-foreground"><?php echo e(__('Sell Security')); ?></p>
                    <div class="space-y-2">
                        <label class="block text-xs text-muted-foreground"><?php echo e(__('Shares to sell')); ?></label>
                        <input type="number" min="1" step="1" wire:model="sellQuantities.<?php echo e($selected->id); ?>" placeholder="0"
                            class="w-full rounded-md border border-border bg-background px-3 py-2 text-sm" />
                        <p class="text-xs text-muted-foreground"><?php echo e(__('Available shares')); ?>: <span class="font-semibold text-foreground"><?php echo e($holding['available_quantity']); ?></span></p>
                    </div>
                    <button type="button" wire:click="placeSellOrder(<?php echo e($selected->id); ?>)"
                        <?php if(! $this->isMarketOpen): echo 'disabled'; endif; ?>
                        class="w-full rounded-md px-3 py-2 text-sm font-semibold <?php echo e($this->isMarketOpen ? 'bg-destructive text-destructive-foreground' : 'cursor-not-allowed bg-gray-400 text-white'); ?>">
                        <?php echo e(__('Submit Sell Request')); ?>

                    </button>
                </div>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>

    <div class="fixed bottom-24 right-4 z-40">
        <button
            type="button"
            wire:click="toggleWatchlist"
            class="flex items-center gap-2 bg-primary text-primary-foreground font-semibold py-3 px-5 rounded-full shadow-lg hover:opacity-90 transition-opacity"
        >
            <i class="fa-solid fa-star h-5 w-5"></i>
            <?php echo e(__('My Watchlist')); ?>

        </button>
    </div>
</div><?php /**PATH /Users/cybertruck/DevProjects/2026/FxZidii/storage/framework/views/livewire/views/c1b724d7.blade.php ENDPATH**/ ?>