<?php
use App\Models\Security;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Attributes\Computed;
use Livewire\Component;
use Livewire\WithPagination;
?>

<div>
    <?php if (isset($component)) { $__componentOriginal3fb04b830347e2c9060ed87f2e59736f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3fb04b830347e2c9060ed87f2e59736f = $attributes; } ?>
<?php $component = App\View\Components\AdminPanel::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-panel'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminPanel::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

         <?php $__env->slot('header', null, []); ?> <?php echo e(__('Securities')); ?> <?php $__env->endSlot(); ?>
         <?php $__env->slot('desc', null, []); ?> <?php echo e(__('Manage manual securities, latest prices, and history logs used by stock providers.')); ?> <?php $__env->endSlot(); ?>
         <?php $__env->slot('button', null, []); ?> 
            <a href="<?php echo e(route('admin.securities.create')); ?>"
                class="bg-blue-500 dark:bg-blue-600 text-white hover:bg-blue-600 dark:hover:bg-blue-700 px-3 py-2 rounded-md float-right text-sm font-bold">
                <?php echo e(__('Add Security')); ?>

            </a>
         <?php $__env->endSlot(); ?>

        <div class="my-4">
            <div class="bg-white dark:bg-gray-800 shadow-sm sm:rounded-lg">
                <div class="px-4 py-5 sm:p-6">
                    <h3 class="text-base font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Search securities')); ?></h3>
                    <div class="mt-3 w-full sm:max-w-xs">
                        <input type="text" wire:model.live.debounce.300ms="search"
                            class="block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 placeholder:text-gray-400 dark:placeholder:text-gray-500 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6"
                            placeholder="<?php echo e(__('Search by name or ticker...')); ?>" />
                    </div>
                </div>
            </div>
        </div>

        <?php echo $this->renderNotification(); ?>


        <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg mt-2">
            <table class="min-w-full divide-y divide-gray-300 dark:divide-gray-600">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="py-3.5 pr-3 pl-4 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Logo')); ?></th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Ticker')); ?></th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Before')); ?></th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Now')); ?></th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Change %')); ?></th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Logs')); ?></th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Description')); ?></th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Status')); ?></th>
                        <th class="py-3.5 pr-4 pl-3 text-right text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Actions')); ?></th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->securities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $security): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                        <?php ($beforeLog = $security->logs->get(1)); ?>
                        <tr class="even:bg-gray-50 dark:even:bg-gray-800/50">
                            <td class="py-4 pr-3 pl-4 text-sm text-gray-900 dark:text-gray-100">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($security->logo): ?>
                                    <img src="<?php echo e(asset($security->logo)); ?>" alt="<?php echo e($security->trading_name); ?>" class="h-8 w-8 rounded object-cover" />
                                <?php else: ?>
                                    <span class="text-xs text-gray-500"><?php echo e(__('None')); ?></span>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e($security->trading_name); ?></td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e($beforeLog ? number_format((float) $beforeLog->price, 4) : '-'); ?></td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e(number_format($security->latestPrice(), 4)); ?></td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e(number_format($security->latestChangePercent(), 4)); ?></td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e($security->logs_count); ?></td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e($security->description ?: '-'); ?></td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">
                                <span class="px-2 py-0.5 text-xs font-semibold rounded-sm <?php echo e($security->is_active ? 'bg-green-500 text-white' : 'bg-red-500 text-white'); ?>">
                                    <?php echo e($security->is_active ? __('Active') : __('Inactive')); ?>

                                </span>
                            </td>
                            <td class="py-4 pr-4 pl-3 text-right space-x-2">
                                <a href="<?php echo e(route('admin.securities.edit', $security->id)); ?>"
                                    class="inline-flex items-center rounded-md bg-indigo-600 px-2.5 py-1 text-xs font-semibold text-white hover:bg-indigo-500"><?php echo e(__('Edit / Logs')); ?></a>

                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($security->is_active): ?>
                                    <button type="button" wire:click="deactivate(<?php echo e($security->id); ?>)"
                                        class="inline-flex items-center rounded-md bg-yellow-500 px-2.5 py-1 text-xs font-semibold text-white hover:bg-yellow-400"><?php echo e(__('Hide')); ?></button>
                                <?php else: ?>
                                    <button type="button" wire:click="activate(<?php echo e($security->id); ?>)"
                                        class="inline-flex items-center rounded-md bg-emerald-600 px-2.5 py-1 text-xs font-semibold text-white hover:bg-emerald-500"><?php echo e(__('Show')); ?></button>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                <button type="button" wire:click="$js.confirmDelete(<?php echo e($security->id); ?>)"
                                    class="inline-flex items-center rounded-md bg-red-600 px-2.5 py-1 text-xs font-semibold text-white hover:bg-red-500"><?php echo e(__('Delete')); ?></button>
                            </td>
                        </tr>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                        <tr>
                            <td colspan="8" class="py-6 text-center text-sm text-gray-500 dark:text-gray-400"><?php echo e(__('No securities found.')); ?></td>
                        </tr>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="mt-8"><?php echo e($this->securities->links()); ?></div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3fb04b830347e2c9060ed87f2e59736f)): ?>
<?php $attributes = $__attributesOriginal3fb04b830347e2c9060ed87f2e59736f; ?>
<?php unset($__attributesOriginal3fb04b830347e2c9060ed87f2e59736f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3fb04b830347e2c9060ed87f2e59736f)): ?>
<?php $component = $__componentOriginal3fb04b830347e2c9060ed87f2e59736f; ?>
<?php unset($__componentOriginal3fb04b830347e2c9060ed87f2e59736f); ?>
<?php endif; ?>

        <?php
        $__scriptKey = '1227097987-0';
        ob_start();
    ?>
        <script>
            $js('confirmDelete', async (securityId) => {
                const result = await Swal.fire({
                    title: 'Delete security?',
                    icon: 'warning',
                    showCancelButton: true,
                });

                if (result.isConfirmed) {
                    $wire.delete(securityId);
                }
            });
        </script>
        <?php
        $__output = ob_get_clean();

        \Livewire\store($this)->push('scripts', $__output, $__scriptKey)
    ?>
</div><?php /**PATH /home/ziidiaik/home.ziiditrader.com/storage/framework/views/livewire/views/f22706da.blade.php ENDPATH**/ ?>