<?php
use App\Models\NotificationState;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Database\Eloquent\Builder;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithPagination;
?>

<div>
    <?php echo $__env->make('partials.trading.topbar', ['title' => __('Notifications')], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="space-y-4 px-4 py-4">
        <div class="flex items-center gap-2">
            <button type="button" wire:click="$set('status', 'all')"
                class="rounded-full px-4 py-2 text-sm font-semibold transition <?php echo e($status === 'all' ? 'bg-primary text-primary-foreground' : 'bg-muted text-muted-foreground'); ?>">
                <?php echo e(__('All')); ?>

            </button>
            <button type="button" wire:click="$set('status', 'unread')"
                class="rounded-full px-4 py-2 text-sm font-semibold transition <?php echo e($status === 'unread' ? 'bg-primary text-primary-foreground' : 'bg-muted text-muted-foreground'); ?>">
                <?php echo e(__('Unread')); ?>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->unreadCount > 0): ?>
                    <span class="ml-1 text-xs">(<?php echo e($this->unreadCount); ?>)</span>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </button>
            <button type="button" wire:click="$set('status', 'read')"
                class="rounded-full px-4 py-2 text-sm font-semibold transition <?php echo e($status === 'read' ? 'bg-primary text-primary-foreground' : 'bg-muted text-muted-foreground'); ?>">
                <?php echo e(__('Read')); ?>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->readCount > 0): ?>
                    <span class="ml-1 text-xs">(<?php echo e($this->readCount); ?>)</span>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </button>
        </div>

        <div>
            <label for="notifications-search" class="sr-only"><?php echo e(__('Search notifications')); ?></label>
            <div class="relative">
                <input id="notifications-search"
                    type="text"
                    wire:model.live.debounce.400ms="search"
                    placeholder="<?php echo e(__('Search name or number')); ?>"
                    class="w-full rounded-full border border-border bg-card py-3 pl-4 pr-11 text-sm text-foreground placeholder:text-muted-foreground focus:border-primary focus:outline-none focus:ring-2 focus:ring-primary/20" />
                <i class="fa-solid fa-magnifying-glass pointer-events-none absolute right-4 top-1/2 -translate-y-1/2 text-muted-foreground"></i>
            </div>
        </div>

        <div class="flex items-center justify-between gap-3">
            <p class="text-base font-bold text-foreground"><?php echo e(__('All Notifications')); ?></p>
            <button type="button" wire:click="markAllAsRead"
                class="text-sm font-semibold text-primary transition hover:opacity-80">
                <?php echo e(__('Mark as Read')); ?>

            </button>
        </div>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($selectedStateIds !== []): ?>
            <div class="rounded-xl border border-border bg-card p-3">
                <button type="button" wire:click="markSelectedAsRead"
                    class="inline-flex items-center gap-2 rounded-lg bg-primary px-3 py-2 text-xs font-semibold text-primary-foreground transition hover:opacity-90">
                    <i class="fa-solid fa-check"></i>
                    <?php echo e(__('Mark selected as read')); ?>

                </button>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <div class="overflow-hidden rounded-2xl border border-border bg-card">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                <?php
                    $title = (string) $state->notification->title;
                    $initials = collect(preg_split('/\s+/', trim($title)) ?: [])->filter()->take(2)->map(fn(string $part): string => strtoupper(substr($part, 0, 1)))->implode('');
                    $initials = $initials !== '' ? $initials : 'NT';
                ?>
                <div <?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processElementKey('notification-state-{{ $state->id }}', get_defined_vars()); ?>wire:key="notification-state-<?php echo e($state->id); ?>"
                    class="flex items-start gap-3 border-b border-border px-3 py-3 last:border-b-0 <?php echo e(is_null($state->read_at) ? 'bg-muted/35' : ''); ?>">
                    <div class="relative mt-1 inline-flex h-11 w-11 shrink-0 items-center justify-center rounded-full bg-muted text-base font-semibold text-foreground">
                        <?php echo e($initials); ?>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(is_null($state->read_at)): ?>
                            <span class="absolute right-0 top-0 h-2.5 w-2.5 rounded-full bg-destructive"></span>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                    <div class="min-w-0 flex-1">
                        <div class="flex items-start justify-between gap-2">
                            <p class="truncate text-base font-semibold text-foreground"><?php echo e($state->notification->title); ?></p>
                            <p class="shrink-0 text-xs text-muted-foreground"><?php echo e($state->notification->created_at?->format('d/m/y H:i')); ?></p>
                        </div>

                        <p class="mt-1 line-clamp-2 text-sm text-muted-foreground"><?php echo e($state->notification->body); ?></p>

                        <div class="mt-2 flex items-center gap-2">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(is_null($state->read_at)): ?>
                                <button type="button" wire:click="markAsRead(<?php echo e($state->id); ?>)"
                                    class="rounded-md border border-border px-2.5 py-1 text-xs font-semibold text-primary transition hover:bg-muted">
                                    <?php echo e(__('Mark read')); ?>

                                </button>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($state->notification->action_url): ?>
                                <a href="<?php echo e($state->notification->action_url); ?>" wire:navigate
                                    class="rounded-md border border-border px-2.5 py-1 text-xs font-semibold text-foreground transition hover:bg-muted">
                                    <?php echo e(__('Open')); ?>

                                </a>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>

                    <label for="notification-state-<?php echo e($state->id); ?>" class="mt-1 inline-flex items-center">
                        <input id="notification-state-<?php echo e($state->id); ?>"
                            type="checkbox"
                            wire:model="selectedStateIds"
                            value="<?php echo e($state->id); ?>"
                            class="h-5 w-5 rounded border-border text-primary focus:ring-primary/30" />
                    </label>
                </div>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                <div class="px-4 py-8 text-center text-sm text-muted-foreground">
                    <?php echo e(__('No notifications found.')); ?>

                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->notifications->hasPages()): ?>
            <div>
                <?php echo e($this->notifications->links()); ?>

            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
</div><?php /**PATH /home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/94fd64b1.blade.php ENDPATH**/ ?>