<?php
use App\Models\PortfolioHolding;
use App\Models\Security;
use App\Models\SecurityOrder;
use App\Models\Wallet;
use App\Models\WalletTransaction;
use App\Mail\AdminTransactionMail;
use App\Services\DefaultCurrencyService;
use App\Services\Sms\SmsAfrikasTalking;
use App\Services\Trading\TradingSettingsService;
use App\Traits\Vrm\Livewire\WithNotifications;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
?>

<div>
    <?php echo $__env->make('partials.trading.topbar', ['title' => 'INVEST'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="px-4 py-4 space-y-4">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($this->notification)): ?>
            <div x-data="{ show: true }" x-show="show" x-transition:enter="transform transition ease-out duration-300"
                x-transition:enter-start="translate-y-3 opacity-0" x-transition:enter-end="translate-y-0 opacity-100"
                x-transition:leave="transform transition ease-in duration-200"
                x-transition:leave-start="translate-y-0 opacity-100" x-transition:leave-end="translate-y-3 opacity-0"
                x-init="setTimeout(() => {
    show = false;
    $wire.clearNotification();
}, 3500)"
                class="fixed inset-x-0 bottom-24 z-[96] px-4 lg:bottom-6 [&_.toast]:mx-auto [&_.toast]:max-w-sm [&_.toast]:w-full">
                <?php echo $this->renderNotification(); ?>

            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <a href="<?php echo e(route('member.trade-now')); ?>" wire:navigate class="inline-flex items-center gap-2 text-sm font-medium text-primary">
            <i class="fa-solid fa-arrow-left h-4 w-4"></i>
            <?php echo e(__('Back to Trade List')); ?>

        </a>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(! $this->isMarketOpen): ?>
            <div class="rounded-lg border border-destructive/50 bg-destructive/10 px-3 py-2 text-sm text-destructive">
                <?php echo e(__('Market is closed for today.')); ?>

            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <div class="bg-card rounded-xl border border-border p-4 space-y-4">
            <div class="flex items-center justify-between gap-3">
                <div class="flex items-center gap-3 min-w-0">
                    <div class="w-10 h-10 bg-secondary rounded-full flex items-center justify-center shrink-0 overflow-hidden">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($this->security->logo)): ?>
                            <img src="<?php echo e(asset($this->security->logo)); ?>" alt="" class="size-10 rounded-full object-cover" />
                        <?php else: ?>
                            <span class="text-xs font-bold text-foreground"><?php echo e(strtoupper(substr($this->security->trading_name, 0, 2))); ?></span>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                    <div class="min-w-0">
                        <p class="text-foreground font-bold text-sm"><?php echo e($this->security->trading_name); ?></p>
                        <p class="text-muted-foreground text-xs truncate"><?php echo e($this->security->name); ?></p>
                    </div>
                </div>

                <div class="text-right">
                    <p class="text-foreground font-bold text-sm"><?php echo e($this->currencyCode); ?> <?php echo e(number_format($this->currentSharePrice, 2)); ?></p>
                    <p class="text-xs text-muted-foreground"><?php echo e(__('Per share')); ?></p>
                </div>
            </div>

            <div class="grid grid-cols-2 gap-3 text-sm">
                <div class="rounded-lg border border-border p-3">
                    <p class="text-xs text-muted-foreground"><?php echo e(__('Available Balance')); ?></p>
                    <p class="font-semibold text-foreground"><?php echo e($this->currencyCode); ?> <?php echo e(number_format($this->wallet->available_balance, 2)); ?></p>
                </div>
                <div class="rounded-lg border border-border p-3">
                    <p class="text-xs text-muted-foreground"><?php echo e(__('Price Per Share')); ?></p>
                    <p class="font-semibold text-foreground"><?php echo e($this->currencyCode); ?> <?php echo e(number_format($this->currentSharePrice, 2)); ?></p>
                </div>
                <div class="rounded-lg border border-border p-3">
                    <p class="text-xs text-muted-foreground"><?php echo e(__('Current Shares')); ?></p>
                    <p class="font-semibold text-foreground"><?php echo e($this->holding['quantity']); ?></p>
                </div>
            </div>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($investmentStep === 'form'): ?>
                <?php
                    $amountValue = (float) ($amount !== '' ? $amount : 0);
                    $estimatedShares = $amountValue > 0 ? (int) floor($amountValue / $this->currentSharePrice) : 0;
                ?>

                <div class="space-y-2">
                    <label for="investment-amount" class="block text-xs text-muted-foreground"><?php echo e(__('Amount to invest')); ?></label>
                    <input
                        id="investment-amount"
                        type="number"
                        min="0.01"
                        step="0.01"
                        wire:model.live.debounce.300ms="amount"
                        placeholder="0.00"
                        class="w-full rounded-md border border-border bg-background px-3 py-2 text-sm text-foreground"
                    />
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-xs text-destructive"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <p class="text-xs text-muted-foreground"><?php echo e(__('Estimated shares')); ?>: <span class="font-semibold text-foreground"><?php echo e(max(0, $estimatedShares)); ?></span></p>
                </div>

                <button
                    type="button"
                    wire:click="goToInvestmentConfirmation"
                    <?php if(! $this->isMarketOpen): echo 'disabled'; endif; ?>
                    class="w-full rounded-xl px-4 py-2.5 text-sm font-semibold <?php echo e($this->isMarketOpen ? 'bg-[#2CB34A] text-white' : 'cursor-not-allowed bg-gray-400 text-white'); ?>"
                >
                    <?php echo e(__('Continue to Confirmation')); ?>

                </button>
            <?php elseif($investmentStep === 'confirm'): ?>
                <?php
                    $confirmedAmount = (float) $amount;
                    $confirmedShares = $confirmedAmount > 0 ? (int) floor($confirmedAmount / $this->currentSharePrice) : 0;
                ?>

                <div class="min-h-[68vh] flex flex-col gap-6">
                    <div class="rounded-3xl border border-border bg-card p-5 space-y-6">
                        <div class="mx-auto size-12 rounded-full bg-[#2CB34A] text-white flex items-center justify-center">
                            <i class="fa-solid fa-sack-dollar text-xl"></i>
                        </div>

                        <p class="text-center text-md font-bold tracking-wide text-foreground"><?php echo e(__('CONFIRM BUY ORDER')); ?></p>

                        <div class="space-y-5 text-sm">
                            <div>
                                <p class="text-[11px] font-semibold uppercase tracking-wide text-muted-foreground"><?php echo e(__('Security')); ?></p>
                                <p class="text-md font-bold text-foreground"><?php echo e($this->security->trading_name); ?></p>
                            </div>
                            <div>
                                <p class="text-[11px] font-semibold uppercase tracking-wide text-muted-foreground"><?php echo e(__('Amount')); ?></p>
                                <p class="text-md font-bold text-foreground"><?php echo e($this->currencyCode); ?> <?php echo e(number_format($confirmedAmount, 2)); ?></p>
                            </div>
                            <div>
                                <p class="text-[11px] font-semibold uppercase tracking-wide text-muted-foreground"><?php echo e(__('Estimated Shares')); ?></p>
                                <p class="text-md font-bold text-foreground"><?php echo e(max(0, $confirmedShares)); ?></p>
                            </div>
                            <div class="flex items-end justify-between gap-3">
                                <div>
                                    <p class="text-[11px] font-semibold uppercase tracking-wide text-muted-foreground"><?php echo e(__('Available Balance')); ?></p>
                                    <p class="text-md font-bold text-foreground"><?php echo e($this->currencyCode); ?> <?php echo e(number_format($this->wallet->available_balance, 2)); ?></p>
                                </div>
                                <button type="button" wire:click="backToInvestmentForm"
                                    class="inline-flex size-10 items-center justify-center rounded-full bg-secondary text-muted-foreground">
                                    <i class="fa-solid fa-pen text-md"></i>
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="grid grid-cols-2 gap-2 mt-auto">
                        <button
                            type="button"
                            wire:click="backToInvestmentForm"
                            class="w-full rounded-xl border border-border bg-background px-4 py-2.5 text-sm font-semibold text-foreground"
                        >
                            <?php echo e(__('Back')); ?>

                        </button>
                        <button
                            type="button"
                            wire:click="submitInvestment"
                            wire:loading.attr="disabled"
                            wire:target="submitInvestment"
                            class="w-full rounded-xl bg-[#2CB34A] px-4 py-2.5 text-sm font-semibold text-white disabled:cursor-not-allowed disabled:opacity-80"
                        >
                            <span wire:loading.remove wire:target="submitInvestment"><?php echo e(__('Confirm Buy')); ?></span>
                            <span wire:loading wire:target="submitInvestment" class="inline-flex items-center gap-2">
                                <i class="fa-solid fa-spinner animate-spin text-sm"></i>
                                <?php echo e(__('Submitting')); ?>

                            </span>
                        </button>
                    </div>
                </div>
            <?php else: ?>
                <div class="min-h-[68vh] flex flex-col">
                    <div class="pt-6 space-y-3 text-center">
                        <div class="mx-auto size-12 rounded-full bg-[#2CB34A] text-white flex items-center justify-center">
                            <i class="fa-solid fa-check text-2xl"></i>
                        </div>
                        <p class="text-md font-extrabold tracking-wide text-foreground"><?php echo e(__('BUY REQUEST SUBMITTED')); ?></p>
                        <p class="text-md font-extrabold tracking-wide text-foreground">
                            <?php echo e(__('AMOUNT: :currency :amount', ['currency' => $this->currencyCode, 'amount' => number_format($submittedInvestmentAmount, 2)])); ?>

                        </p>
                    </div>

                    <div class="my-auto text-center space-y-4 px-8">
                        <p class="text-sm text-muted-foreground"><?php echo e(__('Security')); ?>: <?php echo e($this->security->trading_name); ?></p>
                        <p class="text-sm text-muted-foreground"><?php echo e(__('Shares')); ?>: <?php echo e($submittedInvestmentQuantity); ?></p>
                        <p class="text-md font-medium text-green-600">
                            <?php echo e(__('Your investment request has been received and is pending admin approval.')); ?>

                        </p>
                    </div>

                    <div class="grid grid-cols-2 gap-2 mt-1">
                        <button
                            type="button"
                            wire:click="resetInvestmentFlow"
                            class="w-full rounded-md border border-border bg-background px-4 py-2 text-sm font-semibold text-foreground"
                        >
                            <?php echo e(__('Invest Again')); ?>

                        </button>
                        <a
                            href="<?php echo e(route('member.trade-now')); ?>"
                            wire:navigate
                            class="inline-flex w-full items-center justify-center rounded-md bg-[#2CB34A] px-4 py-2 text-sm font-extrabold uppercase tracking-wide text-white"
                        >
                            <?php echo e(__('Done')); ?>

                        </a>
                    </div>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->hasInvested): ?>
            <div class="bg-card rounded-xl border border-border p-4 space-y-3">
                <div class="flex items-center justify-between">
                    <p class="text-sm font-semibold text-foreground"><?php echo e(__('Investment Log')); ?></p>
                    <span class="text-xs text-muted-foreground">
                        <?php echo e(__('Total Invested')); ?>: <?php echo e($this->currencyCode); ?> <?php echo e(number_format($this->holding['total_invested'], 2)); ?>

                    </span>
                </div>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->investmentLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                    <div class="rounded-lg border border-border px-3 py-2" <?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processElementKey('invest-log-{{ $log[\'id\'] }}', get_defined_vars()); ?>wire:key="invest-log-<?php echo e($log['id']); ?>">
                        <div class="flex items-center justify-between">
                            <p class="text-sm font-semibold text-foreground"><?php echo e($this->currencyCode); ?> <?php echo e(number_format($log['amount'], 2)); ?></p>
                            <span class="text-xs rounded-full px-2 py-0.5 <?php echo e($log['status'] === 'approved' ? 'bg-gain/15 text-gain' : 'bg-secondary text-muted-foreground'); ?>">
                                <?php echo e(ucfirst($log['status'])); ?>

                            </span>
                        </div>
                        <p class="text-xs text-muted-foreground"><?php echo e(__('Shares')); ?>: <?php echo e($log['quantity']); ?></p>
                        <p class="text-xs text-muted-foreground"><?php echo e(__('Invested on')); ?>: <?php echo e($log['date']); ?></p>
                    </div>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                    <p class="text-xs text-muted-foreground"><?php echo e(__('No investment logs yet for this security.')); ?></p>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>

</div><?php /**PATH /home1/xxwewbmy/zidii.fxinvest.io/storage/framework/views/livewire/views/debd74a0.blade.php ENDPATH**/ ?>