<?php
use App\Models\SecurityOrder;
use App\Models\User;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Component;
?>

<div>
    <?php if (isset($component)) { $__componentOriginal3fb04b830347e2c9060ed87f2e59736f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3fb04b830347e2c9060ed87f2e59736f = $attributes; } ?>
<?php $component = App\View\Components\AdminPanel::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-panel'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminPanel::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

         <?php $__env->slot('header', null, []); ?> <?php echo e(__('Edit Member')); ?> <?php $__env->endSlot(); ?>
         <?php $__env->slot('desc', null, []); ?> <?php echo e(__('Review profile, wallet, and portfolio details for this member.')); ?> <?php $__env->endSlot(); ?>
         <?php $__env->slot('button', null, []); ?> 
            <a href="<?php echo e(route('admin.members.index')); ?>"
                class="bg-black dark:bg-gray-700 text-white hover:bg-gray-800 dark:hover:bg-gray-600 px-3 py-2 rounded-md float-right text-sm font-bold">
                <?php echo e(__('Go Back')); ?>

            </a>
         <?php $__env->endSlot(); ?>

        <?php echo $this->renderNotification(); ?>


        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($member): ?>
            <div class="space-y-4">
                <div class="rounded-lg border border-gray-200 bg-white p-4 dark:border-gray-700 dark:bg-gray-800">
                    <p class="text-lg font-semibold text-gray-900 dark:text-gray-100"><?php echo e($member->name); ?></p>
                    <p class="text-sm text-gray-500"><?php echo e($member->email); ?></p>
                    <p class="mt-2 text-sm text-gray-700 dark:text-gray-300"><?php echo e(__('Pending Orders')); ?>: <?php echo e($this->pendingOrdersCount); ?></p>
                    <div class="mt-4 flex gap-3">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($member->is_active): ?>
                            <button type="button" wire:click="suspend"
                                class="rounded-md bg-yellow-500 px-4 py-2 text-sm font-semibold text-white hover:bg-yellow-400"><?php echo e(__('Suspend Account')); ?></button>
                        <?php else: ?>
                            <button type="button" wire:click="activate"
                                class="rounded-md bg-green-600 px-4 py-2 text-sm font-semibold text-white hover:bg-green-500"><?php echo e(__('Activate Account')); ?></button>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>

                <div class="rounded-lg border border-gray-200 bg-white p-4 dark:border-gray-700 dark:bg-gray-800">
                    <p class="text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Wallet')); ?></p>
                    <div class="mt-2 grid gap-2 text-sm text-gray-700 dark:text-gray-300">
                        <p><?php echo e(__('Currency')); ?>: <?php echo e($member->wallet ? app(\App\Services\DefaultCurrencyService::class)->code() : '-'); ?></p>
                        <p><?php echo e(__('Balance')); ?>: <?php echo e(number_format((float) ($member->wallet?->balance ?? 0), 2)); ?></p>
                        <p><?php echo e(__('Used')); ?>: <?php echo e(number_format((float) ($member->wallet?->used_amount ?? 0), 2)); ?></p>
                        <p><?php echo e(__('Earned')); ?>: <?php echo e(number_format((float) ($member->wallet?->earned_amount ?? 0), 2)); ?></p>
                    </div>
                </div>

                <div class="rounded-lg border border-gray-200 bg-white p-4 dark:border-gray-700 dark:bg-gray-800">
                    <p class="text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Dashboard Net Rate')); ?></p>
                    <p class="mt-1 text-xs text-gray-500"><?php echo e(__('Shown to this member as 0.0% p.a on dashboard.')); ?></p>
                    <div class="mt-3 flex flex-col gap-2 sm:flex-row sm:items-end">
                        <div class="w-full sm:max-w-xs">
                            <label for="annual-net-rate" class="mb-1 block text-xs font-medium text-gray-700 dark:text-gray-300"><?php echo e(__('Annual net rate (%)')); ?></label>
                            <input id="annual-net-rate" type="number" step="0.1" min="0" max="1000" wire:model.live="annualNetRatePercent"
                                class="w-full rounded-md border border-gray-300 px-3 py-2 text-sm text-gray-900 focus:border-primary focus:outline-none dark:border-gray-600 dark:bg-gray-900 dark:text-gray-100">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['annualNetRatePercent'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                        <button type="button" wire:click="updateAnnualNetRate"
                            class="rounded-md bg-black px-4 py-2 text-sm font-semibold text-white hover:bg-gray-800 dark:bg-gray-700 dark:hover:bg-gray-600">
                            <?php echo e(__('Save Rate')); ?>

                        </button>
                    </div>
                </div>

                <div class="rounded-lg border border-gray-200 bg-white p-4 dark:border-gray-700 dark:bg-gray-800">
                    <p class="text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Portfolio Holdings')); ?></p>
                    <div class="mt-3 space-y-2">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $member->portfolioHoldings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $holding): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                            <div class="flex items-center justify-between rounded-md border border-gray-200 px-3 py-2 dark:border-gray-700">
                                <p class="text-sm text-gray-900 dark:text-gray-100"><?php echo e($holding->security?->trading_name); ?></p>
                                <p class="text-sm text-gray-600 dark:text-gray-300"><?php echo e(__('Qty')); ?>: <?php echo e($holding->quantity); ?></p>
                            </div>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                            <p class="text-sm text-gray-500"><?php echo e(__('No holdings yet.')); ?></p>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3fb04b830347e2c9060ed87f2e59736f)): ?>
<?php $attributes = $__attributesOriginal3fb04b830347e2c9060ed87f2e59736f; ?>
<?php unset($__attributesOriginal3fb04b830347e2c9060ed87f2e59736f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3fb04b830347e2c9060ed87f2e59736f)): ?>
<?php $component = $__componentOriginal3fb04b830347e2c9060ed87f2e59736f; ?>
<?php unset($__componentOriginal3fb04b830347e2c9060ed87f2e59736f); ?>
<?php endif; ?>
</div><?php /**PATH /home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/2255d21d.blade.php ENDPATH**/ ?>