<?php
use App\Models\Investment;
use App\Models\Wallet;
use App\Models\WalletTransaction;
use App\Jobs\Vrm\SendMail;
use App\Mail\AdminTransactionMail;
use App\Mail\WalletTransactionMail;
use App\Services\DefaultCurrencyService;
use App\Services\MemberNotificationService;
use App\Services\Vrm\InvestmentEmailService;
use App\Traits\Vrm\Livewire\WithNotifications;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Livewire\Attributes\Computed;
use Livewire\Component;
use Livewire\WithPagination;
?>

<div>
    <?php if (isset($component)) { $__componentOriginal3fb04b830347e2c9060ed87f2e59736f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3fb04b830347e2c9060ed87f2e59736f = $attributes; } ?>
<?php $component = App\View\Components\AdminPanel::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-panel'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminPanel::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

         <?php $__env->slot('header', null, []); ?> <?php echo e(__('Investment Portfolio')); ?> <?php $__env->endSlot(); ?>
         <?php $__env->slot('desc', null, []); ?> <?php echo e(__('Review member package subscriptions, gain progress, and maturity status.')); ?> <?php $__env->endSlot(); ?>

        <?php echo $this->renderNotification(); ?>


        <div class="mb-4 grid gap-4 md:grid-cols-2">
            <div>
                <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-100"><?php echo e(__('Status Filter')); ?></label>
                <select wire:model.live="status"
                    class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                    <option value="all"><?php echo e(__('All')); ?></option>
                    <option value="active"><?php echo e(__('Active')); ?></option>
                    <option value="claimed"><?php echo e(__('Claimed')); ?></option>
                    <option value="cancelled"><?php echo e(__('Cancelled')); ?></option>
                    <option value="failed"><?php echo e(__('Failed')); ?></option>
                </select>
            </div>
            <div>
                <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-100"><?php echo e(__('Search Member')); ?></label>
                <input type="text" wire:model.live.debounce.300ms="search"
                    class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 placeholder:text-gray-400 dark:placeholder:text-gray-500 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6"
                    placeholder="<?php echo e(__('Search by member name or email...')); ?>" />
            </div>
        </div>

        <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg mt-2">
            <table class="min-w-full divide-y divide-gray-300 dark:divide-gray-600">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="py-3.5 pr-3 pl-4 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Member')); ?></th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Package')); ?></th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Principal')); ?></th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Expected')); ?></th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Accrued')); ?></th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Progress')); ?></th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Status')); ?></th>
                        <th class="py-3.5 pr-4 pl-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Matures')); ?></th>
                        <th class="py-3.5 pr-4 pl-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Actions')); ?></th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->investments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                        <tr class="even:bg-gray-50 dark:even:bg-gray-800/50">
                            <td class="py-4 pr-3 pl-4 text-sm text-gray-900 dark:text-gray-100">
                                <p class="font-semibold"><?php echo e($investment->user?->name ?? '-'); ?></p>
                                <p class="text-xs text-gray-500"><?php echo e($investment->user?->email ?? '-'); ?></p>
                            </td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e($investment->package?->name ?? '-'); ?></td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e($this->currencyCode); ?> <?php echo e(number_format((float) $investment->principal_amount, 2)); ?></td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e($this->currencyCode); ?> <?php echo e(number_format((float) $investment->expected_return_amount, 2)); ?></td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e($this->currencyCode); ?> <?php echo e(number_format((float) $investment->accrued_amount, 2)); ?></td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">
                                <div class="w-40">
                                    <div class="h-2 rounded bg-gray-200 dark:bg-gray-700">
                                        <div class="h-2 rounded bg-indigo-500" style="width: <?php echo e(max(0, min(100, (int) round($investment->progress_ratio * 100)))); ?>%"></div>
                                    </div>
                                    <p class="mt-1 text-xs text-gray-500"><?php echo e(number_format($investment->progress_ratio * 100, 1)); ?>%</p>
                                </div>
                            </td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e(ucfirst($investment->status)); ?></td>
                            <td class="py-4 pr-4 pl-3 text-sm text-gray-500 dark:text-gray-400"><?php echo e($investment->matures_at?->format('M j, Y g:i A') ?? '-'); ?></td>
                            <td class="py-4 pr-4 pl-3 text-sm text-gray-500 dark:text-gray-400">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($investment->is_active): ?>
                                    <div class="flex w-64 flex-col gap-2">
                                        <div class="flex items-center gap-2">
                                            <input
                                                type="datetime-local"
                                                wire:model="maturityInputs.<?php echo e($investment->id); ?>"
                                                value="<?php echo e(($maturityInputs[$investment->id] ?? $investment->matures_at?->format('Y-m-d\\TH:i'))); ?>"
                                                class="block w-full rounded-md border border-gray-300 bg-white px-2 py-1 text-xs text-gray-900 outline-none focus:border-indigo-500 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100"
                                            />
                                            <button type="button" wire:click="updateMaturity(<?php echo e($investment->id); ?>)"
                                                class="rounded bg-gray-900 px-2 py-1 text-xs font-semibold text-white dark:bg-gray-100 dark:text-gray-900">
                                                <?php echo e(__('Save')); ?>

                                            </button>
                                        </div>
                                        <div class="flex gap-2">
                                            <button type="button" wire:confirm="<?php echo e(__('Close this investment as success?')); ?>" wire:click="closeAsSuccess(<?php echo e($investment->id); ?>)"
                                                class="rounded bg-emerald-600 px-2 py-1 text-xs font-semibold text-white">
                                                <?php echo e(__('Mark Success')); ?>

                                            </button>
                                            <button type="button" wire:confirm="<?php echo e(__('Close this investment as failure?')); ?>" wire:click="closeAsFailure(<?php echo e($investment->id); ?>)"
                                                class="rounded bg-rose-600 px-2 py-1 text-xs font-semibold text-white">
                                                <?php echo e(__('Mark Failure')); ?>

                                            </button>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <span class="text-xs text-gray-400"><?php echo e(__('Closed')); ?></span>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </td>
                        </tr>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                        <tr>
                            <td colspan="9" class="py-6 text-center text-sm text-gray-500 dark:text-gray-400"><?php echo e(__('No investments found.')); ?></td>
                        </tr>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="mt-4"><?php echo e($this->investments->links()); ?></div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3fb04b830347e2c9060ed87f2e59736f)): ?>
<?php $attributes = $__attributesOriginal3fb04b830347e2c9060ed87f2e59736f; ?>
<?php unset($__attributesOriginal3fb04b830347e2c9060ed87f2e59736f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3fb04b830347e2c9060ed87f2e59736f)): ?>
<?php $component = $__componentOriginal3fb04b830347e2c9060ed87f2e59736f; ?>
<?php unset($__componentOriginal3fb04b830347e2c9060ed87f2e59736f); ?>
<?php endif; ?>
</div><?php /**PATH /home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/f7e181dd.blade.php ENDPATH**/ ?>