<?php
use App\Models\Security;
use App\Models\SecurityOrder;
use App\Models\WalletTransaction;
use App\Services\DefaultCurrencyService;
use App\Services\LiveStockService;
use App\Services\Trading\TradingSettingsService;
use App\Models\Wallet;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
?>

<div>
    <?php echo $__env->make('partials.trading.topbar', ['title' => 'TRADE'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('partials.trading.marquee', [
        'securities' => $this->securities,
        'currencyCode' => $this->defaultCurrencyCode,
    ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="space-y-4 px-4 py-4">
        <div class="<?php echo e($this->isMarketOpen ? 'border border-primary/30 bg-primary/10' : 'border border-destructive/30 bg-destructive/10'); ?> flex items-center justify-between rounded-lg px-4 py-3">
            <div class="flex items-center gap-2">
                <i class="fa-solid fa-circle-info h-4 w-4 <?php echo e($this->isMarketOpen ? 'text-primary' : 'text-destructive'); ?>"></i>
                <span class="text-sm font-medium <?php echo e($this->isMarketOpen ? 'text-primary' : 'text-destructive'); ?>">
                    <?php echo e($this->isMarketOpen ? __('Market is open') : __('Market is closed for today.')); ?>

                </span>
            </div>
        </div>

        <div class="rounded-xl border border-border bg-card p-5">
            <p class="mb-1 text-sm text-muted-foreground"><?php echo e(__('Your portfolio value')); ?></p>
            <h2 class="mb-3 text-md font-bold text-foreground"><?php echo e($this->portfolio['currency']); ?> <?php echo e(number_format($this->portfolio['balance'], 2)); ?></h2>
            <div class="hidden items-center justify-between border-t border-border pt-3">
                <span class="text-sm text-muted-foreground"><?php echo e(__('Value')); ?> : <?php echo e($this->portfolio['currency']); ?> <?php echo e(number_format($this->portfolio['balance'] + $this->portfolio['inTrade'], 2)); ?></span>
                <span class="rounded-full px-4 py-1 text-sm font-semibold <?php echo e($this->portfolio['gainLoss'] >= 0 ? 'bg-primary text-primary-foreground' : 'bg-destructive text-destructive-foreground'); ?>">
                    <?php echo e($this->portfolio['gainLoss'] >= 0 ? '+' : ''); ?><?php echo e(number_format($this->portfolio['gainLoss'], 2)); ?>%
                </span>
            </div>
        </div>

        <div class="rounded-xl border border-border bg-card p-5">
            <div class="mb-3 flex items-center gap-2">
                <i class="fa-solid fa-clock h-4 w-4 text-muted-foreground"></i>
                <h3 class="text-sm font-semibold text-foreground"><?php echo e(__('Pending / unapproved transactions')); ?></h3>
            </div>
            <div class="rounded-lg bg-destructive/10 p-4 text-center">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->pendingTransactionsCount > 0): ?>
                    <p class="mb-3 text-sm text-foreground">
                        <?php echo e(__('You have :count pending transaction(s) awaiting admin approval.', ['count' => $this->pendingTransactionsCount])); ?>

                    </p>
                <?php else: ?>
                    <p class="mb-3 text-sm text-foreground"><?php echo e(__('You have no pending transactions.')); ?></p>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <a href="<?php echo e(route('member.account')); ?>" wire:navigate class="inline-block rounded-lg bg-primary px-6 py-2.5 text-sm font-semibold text-primary-foreground"><?php echo e(__('View account')); ?></a>
            </div>
        </div>

        <div class="rounded-xl border border-border bg-card p-4">
            <div class="mb-3 flex items-center gap-2">
                <i class="fa-solid fa-star h-4 w-4 text-primary"></i>
                <h3 class="text-sm font-semibold text-foreground"><?php echo e(__('Your Watchlist')); ?></h3>
            </div>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($this->watchlist) === 0): ?>
                <p class="py-4 text-center text-sm text-muted-foreground"><?php echo e(__('Your watchlist is empty')); ?></p>
            <?php else: ?>
                <div class="space-y-3">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $this->watchlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                        <div class="flex items-center justify-between py-2" <?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processElementKey('watch-{{ $s[\'id\'] }}', get_defined_vars()); ?>wire:key="watch-<?php echo e($s['id']); ?>">
                            <div>
                                <p class="text-sm font-semibold text-foreground"><?php echo e($s['symbol']); ?></p>
                                <p class="text-xs text-muted-foreground"><?php echo e($s['name']); ?></p>
                            </div>
                            <div class="text-right">
                                <p class="text-sm font-semibold text-foreground"><?php echo e(number_format($s['price'], 2)); ?></p>
                                <p class="text-xs <?php echo e($s['change'] >= 0 ? 'text-gain' : 'text-loss'); ?>"><?php echo e($s['change'] >= 0 ? '▲' : '▼'); ?><?php echo e(number_format(abs($s['change']), 2)); ?>%</p>
                            </div>
                        </div>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>

        <div class="fixed bottom-24 right-4 z-40 max-w-lg">
            <a href="<?php echo e(route('member.trade-now')); ?>" wire:navigate class="flex items-center gap-2 rounded-full bg-primary px-6 py-3 font-semibold text-primary-foreground shadow-lg transition-opacity hover:opacity-90">
                <i class="fa-solid fa-cart-shopping h-5 w-5"></i>
                <?php echo e(__('Buy Stocks')); ?>

            </a>
        </div>
    </div>
</div><?php /**PATH /home1/xxwewbmy/zidii.fxinvest.io/storage/framework/views/livewire/views/d80ca511.blade.php ENDPATH**/ ?>