<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="dark">
    <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <title><?php echo e($title ?? config('app.name')); ?></title>
        <link rel="icon" href="/favicon.ico" sizes="any">
        <link rel="icon" href="/favicon.svg" type="image/svg+xml">
        <link rel="apple-touch-icon" href="/apple-touch-icon.png">
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
        <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

    </head>
    <body class="min-h-screen bg-background text-foreground antialiased">
        <div class="min-h-screen bg-background flex flex-col items-center justify-center p-6 max-w-lg mx-auto">
            <a href="<?php echo e(route('home')); ?>" class="flex flex-col items-center gap-2 font-medium mb-6" wire:navigate>
                <span class="text-2xl font-bold text-foreground">FX ZIDII</span>
                <span class="sr-only"><?php echo e(config('app.name')); ?></span>
            </a>
            <div class="w-full flex flex-col gap-6">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </div>
        <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

    </body>
</html>
<?php /**PATH /home/fxporict/zidii.fxpool.io/invest/resources/views/layouts/member/auth.blade.php ENDPATH**/ ?>