<?php
use App\Models\NotificationState;
use Livewire\Attributes\Computed;
use Livewire\Component;
?>

<div wire:poll.10s>
    <a href="<?php echo e(route('member.notifications')); ?>"
        wire:navigate
        class="relative inline-flex h-10 w-10 items-center justify-center rounded-full border border-border bg-card text-foreground transition hover:bg-muted/70"
        aria-label="<?php echo e(__('Notifications')); ?>">
        <i class="fa-regular fa-bell text-base"></i>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->unreadCount > 0): ?>
            <span class="absolute -right-0.5 -top-0.5 inline-flex min-h-5 min-w-5 items-center justify-center rounded-full bg-destructive px-1 text-[10px] font-bold leading-none text-white">
                <?php echo e($this->unreadCount > 99 ? '99+' : $this->unreadCount); ?>

            </span>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </a>
</div><?php /**PATH /home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/0cd0ca39.blade.php ENDPATH**/ ?>