<?php
use App\Models\CommunityPost;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Attributes\Computed;
use Livewire\Component;
use Livewire\WithPagination;
?>

<div>
    <?php if (isset($component)) { $__componentOriginal3fb04b830347e2c9060ed87f2e59736f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3fb04b830347e2c9060ed87f2e59736f = $attributes; } ?>
<?php $component = App\View\Components\AdminPanel::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-panel'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminPanel::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

         <?php $__env->slot('header', null, []); ?> <?php echo e(__('Community Center')); ?> <?php $__env->endSlot(); ?>
         <?php $__env->slot('desc', null, []); ?> <?php echo e(__('Create and manage notice board posts for members.')); ?> <?php $__env->endSlot(); ?>
         <?php $__env->slot('button', null, []); ?> 
            <a href="<?php echo e(route('admin.community.create')); ?>" wire:navigate
                class="rounded-md bg-blue-600 px-3 py-2 text-sm font-bold text-white hover:bg-blue-500">
                <?php echo e(__('Create Post')); ?>

            </a>
         <?php $__env->endSlot(); ?>

        <div class="mb-4 mt-2">
            <input type="text" wire:model.live.debounce.300ms="search"
                class="block w-full rounded-md border border-gray-300 bg-white px-3 py-2 text-sm text-gray-900 outline-none focus:border-indigo-500 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100"
                placeholder="<?php echo e(__('Search by title...')); ?>" />
        </div>

        <?php echo $this->renderNotification(); ?>


        <div class="overflow-hidden rounded-lg shadow-sm ring-1 ring-black/5 dark:ring-white/10">
            <table class="min-w-full divide-y divide-gray-300 dark:divide-gray-600">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="px-4 py-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Title')); ?></th>
                        <th class="px-4 py-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Author')); ?></th>
                        <th class="px-4 py-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Publication Date')); ?></th>
                        <th class="px-4 py-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Status')); ?></th>
                        <th class="px-4 py-3 text-right text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Actions')); ?></th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100 bg-white dark:divide-gray-700 dark:bg-gray-800">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                        <tr>
                            <td class="px-4 py-4 text-sm text-gray-900 dark:text-gray-100"><?php echo e($post->title); ?></td>
                            <td class="px-4 py-4 text-sm text-gray-900 dark:text-gray-100"><?php echo e($post->author?->name ?? '-'); ?></td>
                            <td class="px-4 py-4 text-sm text-gray-900 dark:text-gray-100"><?php echo e(optional($post->published_at)->format('Y-m-d H:i') ?? '-'); ?></td>
                            <td class="px-4 py-4 text-sm">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($post->is_active && $post->published_at && $post->published_at->lte(now())): ?>
                                    <span class="rounded bg-emerald-500 px-2 py-0.5 text-xs font-semibold text-white"><?php echo e(__('Published')); ?></span>
                                <?php elseif($post->is_active && $post->published_at && $post->published_at->isFuture()): ?>
                                    <span class="rounded bg-amber-500 px-2 py-0.5 text-xs font-semibold text-white"><?php echo e(__('Scheduled')); ?></span>
                                <?php else: ?>
                                    <span class="rounded bg-gray-500 px-2 py-0.5 text-xs font-semibold text-white"><?php echo e(__('Disabled')); ?></span>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </td>
                            <td class="px-4 py-4 text-right text-xs">
                                <a href="<?php echo e(route('admin.community.edit', ['post' => $post->id])); ?>" wire:navigate
                                    class="inline-flex items-center rounded-md bg-blue-600 px-2.5 py-1 font-semibold text-white hover:bg-blue-500"><?php echo e(__('Edit')); ?></a>

                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($post->is_active): ?>
                                    <button type="button" wire:click="unpublish(<?php echo e($post->id); ?>)"
                                        class="inline-flex items-center rounded-md bg-yellow-500 px-2.5 py-1 font-semibold text-white hover:bg-yellow-400"><?php echo e(__('Disable')); ?></button>
                                <?php else: ?>
                                    <button type="button" wire:click="publishNow(<?php echo e($post->id); ?>)"
                                        class="inline-flex items-center rounded-md bg-emerald-600 px-2.5 py-1 font-semibold text-white hover:bg-emerald-500"><?php echo e(__('Enable')); ?></button>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                <button type="button" wire:click="$js.confirmDelete(<?php echo e($post->id); ?>)"
                                    class="inline-flex items-center rounded-md bg-red-600 px-2.5 py-1 font-semibold text-white hover:bg-red-500"><?php echo e(__('Delete')); ?></button>
                            </td>
                        </tr>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                        <tr>
                            <td colspan="5" class="px-4 py-6 text-center text-sm text-gray-500 dark:text-gray-400"><?php echo e(__('No community posts found.')); ?></td>
                        </tr>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="mt-4"><?php echo e($this->posts->links()); ?></div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3fb04b830347e2c9060ed87f2e59736f)): ?>
<?php $attributes = $__attributesOriginal3fb04b830347e2c9060ed87f2e59736f; ?>
<?php unset($__attributesOriginal3fb04b830347e2c9060ed87f2e59736f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3fb04b830347e2c9060ed87f2e59736f)): ?>
<?php $component = $__componentOriginal3fb04b830347e2c9060ed87f2e59736f; ?>
<?php unset($__componentOriginal3fb04b830347e2c9060ed87f2e59736f); ?>
<?php endif; ?>

        <?php
        $__scriptKey = '2922473381-0';
        ob_start();
    ?>
        <script>
            $js('confirmDelete', async (postId) => {
                const result = await Swal.fire({
                    title: 'Delete post?',
                    icon: 'warning',
                    showCancelButton: true,
                });

                if (result.isConfirmed) {
                    $wire.delete(postId);
                }
            });
        </script>
        <?php
        $__output = ob_get_clean();

        \Livewire\store($this)->push('scripts', $__output, $__scriptKey)
    ?>
</div><?php /**PATH /home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/2df424ed.blade.php ENDPATH**/ ?>