<?php

use App\Models\NotificationState;
use Livewire\Attributes\Computed;
use Livewire\Component;

return new class extends Component {
    #[Computed]
    public function unreadCount(): int
    {
        return NotificationState::query()
            ->where('user_id', auth()->id())
            ->where('is_active', true)
            ->whereNull('read_at')
            ->whereNull('cleared_at')
            ->whereNull('deleted_at')
            ->count();
    }

    protected function view($data = [])
    {
        return app('view')->file('/home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/0cd0ca39.blade.php', $data);
    }
}; 