<?php

use App\Models\CommunityPost;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Attributes\Computed;
use Livewire\Component;
use Livewire\WithPagination;

return new class extends Component {
    use WithNotifications;
    use WithPagination;

    public string $search = '';

    public function updatedSearch(): void
    {
        $this->resetPage();
    }

    #[Computed]
    public function posts()
    {
        return CommunityPost::query()
            ->with('author:id,name')
            ->when($this->search !== '', function ($query): void {
                $query->where('title', 'like', "%{$this->search}%");
            })
            ->orderByDesc('created_at')
            ->paginate(10);
    }

    public function publishNow(int $postId): void
    {
        $post = CommunityPost::query()->find($postId);

        if (! $post) {
            $this->notifyError(__('Community post not found.'));

            return;
        }

        $post->update([
            'is_active' => true,
            'published_at' => now(),
        ]);

        $this->notifySuccess(__('Community post published.'));
    }

    public function unpublish(int $postId): void
    {
        $post = CommunityPost::query()->find($postId);

        if (! $post) {
            $this->notifyError(__('Community post not found.'));

            return;
        }

        $post->update([
            'is_active' => false,
        ]);

        $this->notifyInfo(__('Community post disabled.'));
    }

    public function delete(int $postId): void
    {
        $post = CommunityPost::query()->find($postId);

        if (! $post) {
            $this->notifyError(__('Community post not found.'));

            return;
        }

        $post->delete();

        $this->notifySuccess(__('Community post deleted.'));
    }

    protected function view($data = [])
    {
        return app('view')->file('/home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/2df424ed.blade.php', $data);
    }
}; 