<?php

use App\Models\User;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Attributes\Computed;
use Livewire\Component;
use Livewire\WithPagination;

return new class extends Component {
    use WithNotifications;
    use WithPagination;

    public string $search = '';
    public int $perPage = 10;

    public function updatedSearch(): void
    {
        $this->resetPage();
    }

    public function updatedPerPage(): void
    {
        $this->resetPage();
    }

    #[Computed]
    public function members()
    {
        return User::query()
            ->whereHas('roles', fn ($query) => $query->where('id', 3))
            ->when($this->search !== '', function ($query): void {
                $query->where(function ($innerQuery): void {
                    $innerQuery->where('name', 'like', "%{$this->search}%")
                        ->orWhere('email', 'like', "%{$this->search}%");
                });
            })
            ->orderByDesc('created_at')
            ->paginate($this->perPage);
    }

    public function activate(int $memberId): void
    {
        $member = User::query()->find($memberId);

        if (! $member) {
            $this->notifyError(__('Member not found.'));

            return;
        }

        $member->forceFill([
            'is_active' => true,
            'email_verified_at' => $member->email_verified_at ?? now(),
        ])->save();
        $this->notifySuccess(__('Member account approved and activated.'));
    }

    public function suspend(int $memberId): void
    {
        $member = User::query()->find($memberId);

        if (! $member) {
            $this->notifyError(__('Member not found.'));

            return;
        }

        $member->update(['is_active' => false]);
        $this->notifySuccess(__('Member account suspended.'));
    }

    protected function view($data = [])
    {
        return app('view')->file('/home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/45063a3e.blade.php', $data);
    }
}; 