<?php

use App\Models\CommunityPost;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Str;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithPagination;

return new #[Layout('layouts.trading')] class extends Component {
    use WithPagination;

    public int $perPage = 5;

    #[Computed]
    public function posts(): LengthAwarePaginator
    {
        return CommunityPost::query()
            ->published()
            ->with('author:id,name,username')
            ->orderByDesc('published_at')
            ->paginate($this->perPage);
    }

    public function excerpt(string $html): string
    {
        return Str::limit(trim(strip_tags($html)), 240);
    }

    protected function view($data = [])
    {
        return app('view')->file('/home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/543c9bb1.blade.php', $data);
    }
}; 